<?php
/* --------------------------------------------------------------
 malibu.lang.inc.php 2023-09-08
 Gambio GmbH
 http://www.gambio.de

 Copyright (c) 2023 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

$t_language_text_section_content_array = [
    'basics.title' => 'Basic',
    'basics.responsive.title' => 'Responsive',
    'basics.responsive.options.main-heading-mobile-visibility' => 'Mobil sichtbar',

    'basics.general.title' => 'Allgemein',
    'basics.general.options.brand-primary' => 'Primärfarbe',
    'basics.general.options.brand-secondary' => 'Sekundäre Farbe',
    'basics.general.options.gx-logo' => 'Logo',

    'basics.typo.title' => 'Typografie',
    'basics.typo.options.font-family-sans-serif' => 'Schriftart',
    'basics.typo.options.text-color' => 'Textfarbe',
    'basics.typo.options.font-size-base' => 'Textgröße',
    'basics.typo.options.gx-font-import-url' => 'Google Web Font Url',

    'basics.background.title' => 'Hintergrund',
    'basics.background.options.gx-body-bg-color' => 'Farbe',
    'basics.background.options.gx-body-bg-image-url' => 'Bild',

    'basics.navigationMenu.title' => 'Navigation Menü',
    'basics.navigationMenu.options.gx-cat-navbar-bg-color' => 'Hintergrund Farbe',
    'basics.navigationMenu.options.navbar-default-link-color' => 'Link Farbe',
    'basics.navigationMenu.options.unique-id' => 'Schrift',

    'areas.header.title' => 'Header',
    'areas.headervariant.title' => 'Header Varianten',
    'areas.header.variants.title' => 'Varianten',
    'areas.header.variants.headerVariant.options.fullscreen' => 'Fullscreen',
    'areas.header.variants.headerVariant.options.fullscreen.thumbnail' => '//placehold.it/800x150?text=Header {Vollbild}',
    'areas.header.variants.headerVariant.options.boxed' => 'Boxed',
    'areas.header.variants.headerVariant.options.boxed.thumbnail' => '\/\/placehold.it\/800x150?text=Header {Boxed}',
    'areas.header.variants.headerVariant.options.bordered' => 'Bordered',
    'areas.header.variants.headerVariant.options.bordered.thumbnail' => '\/\/placehold.it\/800x150?text=Header {Eingerahmt}',
    'areas.header.variants.headerVariant.options.hero' => 'Hero',
    'areas.header.variants.headerVariant.options.default' => 'Standard',
    'areas.header.variants.headerVariant.options.default.thumbnail' => '\/\/placehold.it\/800x150?text=Standard',
    'areas.header.variants.headerVariant.options.hero.thumbnail' => '\/\/placehold.it\/800x150?text=Header {Hero}',

    'areas.pages.title' => 'Seiten',
    'areas.pages.homepage.title' => 'Homepage',
    'areas.pages.homepage.background.title' => 'Hintergrund',
    'areas.pages.homepage.background.options.homepage-background-option' => 'Hintergrund (Bezeichnung)',

    'areas.pages.homepage.typo.title' => 'Typografie',
    'areas.pages.homepage.typo.options.pages-homepage-typo' => 'Schriftart',
    'areas.pages.homepage.typo.options.pages-homepage-text-color' => 'Textfarbe',

    'areas.pages.homepage.single-page.title' => 'Einzelseite',
    'areas.pages.homepage.single-page.single-page-sub.title' => 'Einzelunterseite',
    'areas.pages.homepage.single-page.single-page-sub-main-section.title' => 'Hauptbereich',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.title' => 'Allgemein',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-name' => 'Titel',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-id' => 'ID',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-class' => 'Klasse',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-height' => 'Höhe',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-position' => 'Position',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.sub-page-text-color' => 'Textfarbe',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-heading-bg-image' => 'Hintergrund',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.sub-page-typo' => 'Schriftart',

    'areas.pages.homepage-single-page.grid.title' => 'Das Grid',
    'areas.pages.homepage-single-page.grid.options.fullwidth' => '100%',
    'areas.pages.homepage-single-page.grid.options.fifty-fifty' => '50%x50%',
    'areas.pages.homepage-single-page.grid.options.thirty-three-sixty-six' => '33%x66%',
    'areas.pages.homepage-single-page.grid.options.sixty-six-thirty-three' => '66%x33%',
    'areas.pages.homepage-single-page.grid.options.twenty-five-seventy-five' => '25%x75%',
    'areas.pages.homepage-single-page.grid.options.seventy-five-twenty-five' => '75%x25%',
    'areas.pages.homepage-single-page.grid.options.three-thirty-three' => '33%x33%x33%',
    'areas.pages.homepage-single-page.grid.options.four-twenty-five' => '25%x25%x25%x25%',

    'areas.pages.homepage-single-page.responsive.title' => 'Responsive',
    'areas.pages.homepage-single-page.responsive.options.main-heading-mobile-visibility' => 'Sichtbar auf Mobile',
    'areas.pages.homepage-single-page.responsive.options.main-heading-image-direction' => 'Landscape Bild',

    'areas.pages.homepage-single-page.distances.title' => 'Abstände',
    'areas.pages.homepage-single-page.distances.option.main-heading-margin' => 'Margin',

    'areas.pages.homepage-single-page.border.title' => 'Rahmen',
    'areas.pages.homepage-single-page.border.options.main-heading-border' => 'Rahmenbreite',
    'areas.pages.homepage-single-page.border.options.main-heading-style' => 'Stil',
    'areas.pages.homepage-single-page.border.options.main-heading-border-color' => 'Farbe',

    'areas.footer.title' => 'Footer',
    'areas.footerVariant.title' => 'Footer Varianten',
    'areas.footer.variants.title' => 'Varianten',
    'areas.footer.variants.footerVariant.options.fullscreen' => 'Fullscreen',
    'areas.footer.variants.footerVariant.options.boxed' => 'Boxed',
    'areas.footer.variants.footerVariant.options.bordered' => 'Bordered',
    'areas.footer.variants.footerVariant.options.hero' => 'Hero',

    'areas.general.title' => 'Allgemein',
    'areas.general.layout.title' => 'Layout',
    'areas.general.layout.options.gx-body-wrap' => 'Eingerahmter Shop',
    'areas.general.layout.options.gx-topbar-wrap' => 'Top-Navigation wrappen',
    'areas.general.layout.options.gx-categories-wrap' => 'Kategorieleiste wrappen',
    'areas.general.layout.options.gx-center-categories' => 'Kategorien wrappen',
    'areas.general.layout.options.gx-header-fixed' => 'Kopfzeile fixiert',
    'areas.general.layout.options.gx-header-wrap' => 'Kopfzeile wrappen',
    'areas.general.layout.options.gx-stage-wrap' => 'Slider wrappen',
    'areas.general.layout.options.gx-footer-wrap' => 'Footer wrappen',
    'areas.general.layout.options.gx-logo-horizontal' => 'Logo horizontal ausrichten',
    'areas.general.layout.options.gx-stage-below-header' => 'Slider unter der Kopfzeile',
    'areas.general.layout.options.screen-lg' => 'Maximalbreite',
    'areas.general.layout.options.gx-body-padding-top' => 'Abstand oben',
    'areas.general.layout.options.gx-body-padding-bottom' => 'Abstand unten',

    'areas.general.colors.title' => 'Farben',
    'areas.general.colors.options.brand-primary' => 'Hauptfarbe',
    'areas.general.colors.options.text-color' => 'Textfarbe',
    'areas.general.colors.options.link-color' => 'Linkfarbe',
    'areas.general.colors.options.gx-breadcrumb-color' => 'Breadcrumb-Farbe',
    'areas.general.colors.options.gx-no-rating-hint-color' => 'Schriftfarbe Keine Bewertungen Hinweis',

    'areas.general.background.title' => 'Hintergrund',
    'areas.general.background.options.gx-body-bg' => 'Hintergrund',
    'areas.general.background.options.gx-wrapper-bg' => 'Hintergrund des Containers',

    'areas.general.font.title' => 'Schrift',
    'areas.general.font.options.gx-font-import-url' => 'Google-Webfonts-Url',
    'areas.general.font.options.pages-homepage-typo' => 'Schriftart',
    'areas.general.font.options.font-size-base' => 'Schriftgröße',
    'areas.general.font.options.font-size-h1' => 'Schriftgröße H1',
    'areas.general.font.options.font-size-h2' => 'Schriftgröße H2',
    'areas.general.font.options.font-size-h3' => 'Schriftgröße H3',
    'areas.general.font.options.font-size-h4' => 'Schriftgröße H4',
    'areas.general.font.options.font-size-h5' => 'Schriftgröße H5',
    'areas.general.font.options.font-size-h6' => 'Schriftgröße H6',
    'areas.general.font.options.headings-color' => 'Überschriftenfarbe',
    'areas.general.font.options.headings-font-weight' => 'Überschriftenstärke',

    'areas.general.table.title' => 'Tabellen',
    'areas.general.table.options.gx-table-headline-color' => 'Schriftfarbe Tabellenüberschrift',
    'areas.general.table.options.gx-table-body-color-even' => 'Schriftfarbe gerade Zeile',
    'areas.general.table.options.gx-table-body-color-odd' => 'Schriftfarbe ungerade Zeile',
    'areas.general.table.options.gx-table-border-color' => 'Rahmenfarbe',
    'areas.general.table.options.gx-table-even-row-bg' => 'Hintergrund gerade Zeile',
    'areas.general.table.options.gx-table-odd-row-bg' => 'Hintergrund ungerade Zeile',
    'areas.general.table.options.gx-table-bg' => 'Hintergrundfarbe',

    'areas.general.roundedCorners.title' => 'Abgerundete Ecken',
    'areas.general.roundedCorners.options.border-radius-base' => 'Eckenradius normal',
    'areas.general.roundedCorners.options.border-radius-large' => 'Eckenradius groß',
    'areas.general.roundedCorners.options.border-radius-small' => 'Eckenradius klein',
    'areas.general.roundedCorners.options.gx-wrapper-border-radius' => 'Eckenradius des eingerahmten Shops',
    'areas.general.roundedCorners.options.gx-cat-navbar-border-radius' => 'Eckenradius des horizontalen Kategoriemenüs',
    'areas.general.roundedCorners.options.gx-cart-border-radius' => 'Eckenradius der Warenkorb-Summenbox',

    'areas.general.pageUpButton.title' => 'Page-Up-Button',
    'areas.general.pageUpButton.options.gx-pageup-color' => 'Schriftfarbe',
    'areas.general.pageUpButton.options.gx-pageup-hover-color' => 'Schriftfarbe Hover',
    'areas.general.pageUpButton.options.gx-pageup-bg-color' => 'Hintergrundfarbe',
    'areas.general.pageUpButton.options.gx-pageup-hover-bg-color' => 'Hintergrundfarbe Hover',
    'areas.general.pageUpButton.options.gx-pageup-align-left' => 'Button links ausrichten',
    'areas.general.pageUpButton.options.gx-pageup-vertical-space-bottom' => 'Vertikaler Abstand',

    'areas.general.buttons.title' => 'Buttons',
    'areas.general.buttons.options.gx-btn-border-radius' => 'Abgerundete Ecken',
    'areas.general.buttons.options.gx-btn-text-transform' => 'Texttransformation',
    'areas.general.buttons.options.gx-btn-primary-color' => 'Schriftfarbe',
    'areas.general.buttons.options.gx-btn-primary-bg' => 'Hintergrund Primary-Button',
    'areas.general.buttons.options.gx-btn-primary-border' => 'Rahmenfarbe Primary-Button',
    'areas.general.buttons.options.gx-btn-default-color' => 'Schriftfarbe',
    'areas.general.buttons.options.gx-btn-default-bg' => 'Hintergrund Default-Button',
    'areas.general.buttons.options.gx-btn-default-border' => 'Rahmenfarbe Default-Button',
    'areas.general.buttons.general-fieldset.title' => 'Allgemein',
    'areas.general.buttons.primary-fieldset.title'=> 'Primär',
    'areas.general.buttons.default-fieldset.title'=> 'Default',
    'areas.general.buttons.add-to-cart-fieldset.title' => 'In den Warenkorb',
    'areas.general.buttons.options.gx-btn-calltoaction-color' => 'Schriftfarbe',
    'areas.general.buttons.options.gx-btn-calltoaction-bg' => 'Hintergrund in den Warenkorb-Button',
    'areas.general.buttons.options.gx-btn-calltoaction-border' => 'Rahmenfarbe in den Warenkorb-Button',

    'areas.general.borders.title' => 'Trennlinien',
    'areas.general.borders.options.gx-headline-border-color' => 'Linienfarbe Überschriften',
    'areas.general.borders.options.gx-footer-boxes-border-color' => 'Rahmenfarbe Footer-Boxen',
    'areas.general.borders.options.gx-checkout-headline-border-color' => 'Linienfarbe Überschriften im Checkout',
    'areas.general.borders.options.gx-pagination-border-color' => 'Rahmenfarbe Pagination',
    'areas.general.borders.options.gx-product-list-border-color' => 'Rahmenfarbe Produktlisten und Kacheln',
    'areas.general.borders.options.gx-product-info-border-color' => 'Farbe der Trennlinien Produktdetails-Box',

    'areas.general.alerts.title' => 'Hinweise',
    'areas.general.alerts.options.gx-alert-danger-color' => 'Schriftfarbe Fehler',
    'areas.general.alerts.options.gx-alert-success-color' => 'Schriftfarbe Erfolg',
    'areas.general.alerts.options.gx-alert-info-color' => 'Schriftfarbe Info',
    'areas.general.alerts.options.gx-alert-warning-color' => 'Schriftfarbe Warnung',
    'areas.general.alerts.options.gx-alert-danger-border' => 'Rahmenfarbe Fehler',
    'areas.general.alerts.options.gx-alert-success-border' => 'Rahmenfarbe Erfolg',
    'areas.general.alerts.options.gx-alert-info-border' => 'Rahmenfarbe Info',
    'areas.general.alerts.options.gx-alert-warning-border' => 'Rahmenfarbe Warnung',
    'areas.general.alerts.options.gx-alert-danger-bg' => 'Hintergrund Fehler',
    'areas.general.alerts.options.gx-alert-success-bg' => 'Hintergrund Erfolg',
    'areas.general.alerts.options.gx-alert-warning-bg' => 'Hintergrund Warnung',
    'areas.general.alerts.options.gx-alert-info-bg' => 'Hintergrund Info',

    'areas.general.qrCodes.title' => 'QR-Codes',
    'areas.general.qrCodes.options.gx-qr-code-color' => 'Farbe des QR-Codes',
    'areas.general.qrCodes.options.gx-qr-code-bg-color' => 'Hintergrundfarbe des QR-Codes',

    'areas.general.modals.title' => 'Modal-Fenster',
    'areas.general.modals.options.gx-modal-bg' => 'Hintergrund',

    'areas.header.general.title' => 'Allgemein',
    'areas.header.general.options.gx-header-bg' => 'Hintergrund',
    'areas.header.general.options.gx-header-bg-mobile' => 'Hintergrund Mobil',
    'areas.header.general.options.gx-header-bg-sticky' => 'Hintergrund Sticky',
    'areas.header.general.options.gx-header-height' => 'Höhe',
    'areas.header.general.options.gx-header-height-mobile' => 'Höhe Mobil',
    'areas.header.general.options.gx-header-height-sticky' => 'Höhe Sticky',
    'areas.header.general.options.gx-menu-mobile-icon-color' => 'Farbe des Menü-Icons Mobile',

    'areas.header.logo.title' => 'Logo',
    'areas.header.logo.options.gx-hide-logo-col' => 'Logo im Header ausblenden',
    'areas.header.logo.options.gx-header-col-sm' => 'Grid-Spalten Klein',
    'areas.header.logo.options.gx-header-col-md' => 'Grid-Spalten Medium',
    'areas.header.logo.options.gx-header-col-lg' => 'Grid-Spalten Groß',
    'areas.header.logo.options.gx-brand-height' => 'Logo Höhe',
    'areas.header.logo.options.gx-brand-width-mobile' => 'Logo Max-Breite Mobil',
    'areas.header.logo.options.gx-brand-height-sticky' => 'Logo Höhe Sticky',

    'areas.header.search.title' => 'Suche',
    'areas.header.search.options.gx-show-search-top-nav' => 'Suche in Top-Navigation anzeigen',
    'areas.header.search.options.gx-hide-search-col' => 'Suche im Header ausblenden',
    'areas.header.search.options.gx-search-mobile-icon-color' => 'Farbe des Suche-Icons Mobile',
    'areas.header.search.options.gx-search-height' => 'Suche Höhe',
    'areas.header.search.options.gx-search-height-sticky' => 'Suche Höhe Sticky',
    'areas.header.search.options.gx-search-padding-vertical' => 'vertikaler Abstand',
    'areas.header.search.options.gx-search-padding-vertical-sticky' => 'vertikaler Abstand Sticky',
    'areas.header.search.options.gx-search-margin-vertical' => 'vertikaler äußerer Abstand',
    'areas.header.search.options.gx-search-margin-vertical-sticky' => 'vertikaler äußerer Abstand Sticky',
    'areas.header.search.options.gx-search-col-sm' => 'Grid-Spalten Klein',
    'areas.header.search.options.gx-search-col-md' => 'Grid-Spalten Medium',
    'areas.header.search.options.gx-search-col-lg' => 'Grid-Spalten Groß',

    'areas.header.customContent.title' => 'Freigestaltbarer Bereich',
    'areas.header.customContent.options.gx-hide-custom-1-col' => 'Frei gestaltbaren Bereich im Header ausblenden',
    'areas.header.customContent.options.gx-custom-1-col-height' => 'Höhe',
    'areas.header.customContent.options.gx-custom-1-col-height-sticky' => 'Höhe Sticky',
    'areas.header.customContent.options.gx-header-custom-col-sm' => 'Grid-Spalten Klein',
    'areas.header.customContent.options.gx-header-custom-col-md' => 'Grid-Spalten Medium',
    'areas.header.customContent.options.gx-header-custom-col-lg' => 'Grid-Spalten Groß',

    'areas.header.smallShoppingCart.title' => 'Kleiner Warenkorb',
    'areas.header.smallShoppingCart.options.gx-hide-cart-col' => 'Warenkorb im Header ausblenden',
    'areas.header.smallShoppingCart.options.gx-cart-icon-color' => 'Farbe des Icons',
    'areas.header.smallShoppingCart.options.gx-cart-sticky-icon-color' => 'Farbe des Icons Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-mobile-icon-color' => 'Farbe des Icons Mobile',
    'areas.header.smallShoppingCart.options.gx-cart-text-color' => 'Textfarbe',
    'areas.header.smallShoppingCart.options.gx-cart-sticky-text-color' => 'Textfarbe Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-height' => 'Höhe',
    'areas.header.smallShoppingCart.options.gx-cart-height-sticky' => 'Höhe Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-padding-vertical' => 'Vertikaler Abstand',
    'areas.header.smallShoppingCart.options.gx-cart-padding-vertical-sticky' => 'Vertikaler Abstand Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-margin-vertical' => 'Vertikaler äußerer Abstand',
    'areas.header.smallShoppingCart.options.gx-cart-margin-vertical-sticky' => 'Vertikaler äußerer Abstand Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-col-sm' => 'Grid-Spalten Klein',
    'areas.header.smallShoppingCart.options.gx-cart-col-md' => 'Grid-Spalten Medium',
    'areas.header.smallShoppingCart.options.gx-cart-col-lg' => 'Grid-Spalten Groß',

    'areas.columnDistribution.title' => 'Spaltenaufteilung',
    'areas.columnDistribution.desktops.title' => 'Groß (Desktops)',
    'areas.columnDistribution.desktops.options.gx-left-col-lg' => 'Links Grid-Spalten Groß',
    'areas.columnDistribution.desktops.options.gx-right-col-lg' => 'Rechts Grid-Spalten Groß',
    'areas.columnDistribution.desktops.options.gx-main-col-lg' => 'Hauptspalte Grid-Spalten Groß',

    'areas.columnDistribution.medium.title' => 'Medium (Tablet Landscape)',
    'areas.columnDistribution.medium.options.gx-left-col-md' => 'Links Grid-Spalten Medium',
    'areas.columnDistribution.medium.options.gx-right-col-md' => 'Rechts Grid-Spalten Medium',
    'areas.columnDistribution.medium.options.gx-main-col-md' => 'Hauptspalte Grid-Spalten Medium',

    'areas.columnDistribution.small.title' => 'Klein (Tablet Portrait)',
    'areas.columnDistribution.small.options.gx-left-col-sm' => 'Links Grid-Spalten Klein',
    'areas.columnDistribution.small.options.gx-right-col-sm' => 'Rechts Grid-Spalten Klein',
    'areas.columnDistribution.small.options.gx-main-col-sm' => 'Hauptspalte Grid-Spalten Klein',

    'areas.columnDistribution.subCategories.title' => 'Unterkategorien',
    'areas.columnDistribution.subCategories.options.gx-sub-cat-col-sm' => 'Gridspalten Unterkategorien klein',
    'areas.columnDistribution.subCategories.options.gx-sub-cat-col-md' => 'Gridspalten Unterkategorien mittel',
    'areas.columnDistribution.subCategories.options.gx-sub-cat-col-lg' => 'Gridspalten Unterkategorien groß',

    'areas.footer.footerHeader.title' => 'Footer Header',
    'areas.footer.footerHeader.options.gx-footer-header-min-height' => 'Mindesthöhe',
    'areas.footer.footerHeader.options.gx-footer-header-color' => 'Schriftfarbe',
    'areas.footer.footerHeader.options.gx-footer-header-bg' => 'Hintergrund',
    'areas.footer.footerHeader.options.gx-footer-header-use-content-zone' => 'Verwendung als Content Zone',

    'areas.footer.footerBody.title' => 'Footer Body',
    'areas.footer.footerBody.options.gx-footer-min-height' => 'Mindesthöhe',
    'areas.footer.footerBody.options.gx-footer-height' => 'Höhe',
    'areas.footer.footerBody.options.gx-footer-color' => 'Schriftfarbe',
    'areas.footer.footerBody.options.gx-footer-link-color' => 'Linkfarbe Footer',
    'areas.footer.footerBody.options.gx-footer-link-hover-color' => 'Linkfarbe Hoover Footer',
    'areas.footer.footerBody.options.gx-footer-line-height' => 'Zeilenabstand Footer',
    'areas.footer.footerBody.options.gx-footer-bg' => 'Hintergrund',

    'areas.footer.footerColumn1.title' => 'Footer Spalte 1',
    'areas.footer.footerColumn1.options.gx-hide-footer-col-1' => 'Spalte 1 ausblenden',
    'areas.footer.footerColumn1.options.gx-footer-col-1-xs' => 'Grid-Spalten Klein',
    'areas.footer.footerColumn1.options.gx-footer-col-1-sm' => 'Grid-Spalten Medium',
    'areas.footer.footerColumn1.options.gx-footer-col-1-lg' => 'Grid-Spalten Groß',

    'areas.footer.footerColumn2.title' => 'Footer Spalte 2',
    'areas.footer.footerColumn2.options.gx-hide-footer-col-2' => 'Spalte 2 ausblenden',
    'areas.footer.footerColumn2.options.gx-footer-col-2-xs' => 'Grid-Spalten Klein',
    'areas.footer.footerColumn2.options.gx-footer-col-2-sm' => 'Grid-Spalten Medium',
    'areas.footer.footerColumn2.options.gx-footer-col-2-lg' => 'Grid-Spalten Groß',

    'areas.footer.footerColumn3.title' => 'Footer Spalte 3',
    'areas.footer.footerColumn3.options.gx-hide-footer-col-3' => 'Spalte 3 ausblenden',
    'areas.footer.footerColumn3.options.gx-footer-col-3-xs' => 'Grid-Spalten Klein',
    'areas.footer.footerColumn3.options.gx-footer-col-3-sm' => 'Grid-Spalten Medium',
    'areas.footer.footerColumn3.options.gx-footer-col-3-lg' => 'Grid-Spalten Groß',

    'areas.footer.default.title' => 'Standard',
    'areas.footer.default.thumbnail' => '\/\/placehold.it\/800x150?text=Standard',

    'areas.footer.footerColumn4.title' => 'Footer Spalte 4',
    'areas.footer.footerColumn4.options.gx-hide-footer-col-4' => 'Spalte 4 ausblenden',
    'areas.footer.footerColumn4.options.gx-footer-col-4-xs' => 'Grid-Spalten Klein',
    'areas.footer.footerColumn4.options.gx-footer-col-4-sm' => 'Grid-Spalten Medium',
    'areas.footer.footerColumn4.options.gx-footer-col-4-lg' => 'Grid-Spalten Groß',

    'areas.products.title' => 'Produkte',
    'areas.products.articleImage.title' => 'Artikelbild',
    'areas.products.articleImage.options.gx-product-info-stage-height' => 'Höhe',
    'areas.products.articleImage.options.gx-product-info-stage-height-mobile' => 'Höhe Mobil',
    'areas.products.articleImage.options.gx-product-info-layer-stage-height' => 'Höhe Lightbox',
    'areas.products.articleImage.options.gx-product-info-layer-stage-height-mobile' => 'Höhe Lightbox Mobil',
    'areas.products.articleImage.options.gx-product-info-thumbnail-width' => 'Breite der Thumbnails',
    'areas.products.articleImage.options.gx-product-info-thumbnail-width-mobile' => 'Breite der Thumbnails Mobil',
    'areas.products.articleImage.options.gx-product-info-img-bg' => 'Hintergrund',

    'areas.products.productList.title' => 'Produktliste',
    'areas.products.productList.options.gx-product-bg' => 'Hintergrund',
    'areas.products.productList.options.gx-gallery-bg' => 'Hintergrund der Galerie',
    'areas.products.productList.options.gx-product-listing-col-xs' => 'Grid-Spalten Mobil',
    'areas.products.productList.options.gx-product-listing-col-sm' => 'Grid-Spalten Klein',
    'areas.products.productList.options.gx-product-listing-col-md' => 'Grid-Spalten Medium',
    'areas.products.productList.options.gx-product-listing-col-lg' => 'Grid-Spalten Groß',
    'areas.products.productList.options.gx-products-name-height' => 'Höhe des Produktnamens in der Kachel',
    'areas.products.productList.options.gx-products-price-height' => 'Höhe des Preises in der Kachel',
    'areas.products.productList.options.gx-ribbons-padding' => 'Abstand zwischen Ribbons und Artikelbild',
    'areas.products.productList.options.gx-product-listing-image-height' => 'Höhe des Produktbildes Kachel',
    'areas.products.productList.options.gx-product-listing-image-height-mobile' => 'Höhe des Produktbildes Kachel mobil',
    'areas.products.productList.options.gx-product-listing-gallery-image-height' => 'Höhe des Galeriebildes Flyover',
    'areas.products.productList.options.gx-product-listing-gallery-width' => 'Breite der Galerie',
    'areas.products.productList.options.gx-show-shipping-in-tile' => 'Lieferzeit in Kachel immer anzeigen',

    'areas.products.tabs.title' => 'Tabs',
    'areas.products.tabs.options.gx-tab-color' => 'Schriftfarbe',
    'areas.products.tabs.options.gx-tab-color-active' => 'Schriftfarbe aktiver Tab',
    'areas.products.tabs.options.gx-tab-border-color' => 'Rahmenfarbe',
    'areas.products.tabs.options.gx-tab-border-color-active' => 'Rahmenfarbe aktiver Tab',
    'areas.products.tabs.options.gx-tab-container-border-color' => 'Rahmenfarbe Tab Container',
    'areas.products.tabs.options.gx-tab-bg' => 'Hintergrund',
    'areas.products.tabs.options.gx-tab-bg-active' => 'Hintergrund aktiver Tab',

    'areas.products.ribbons.title' => 'Ribbons',
    'areas.products.ribbons.options.gx-ribbon-new-active' => 'Ribbon Neu anzeigen',
    'areas.products.ribbons.options.gx-ribbon-new-bg' => 'Hintergrundfarbe Neu',
    'areas.products.ribbons.options.gx-ribbon-new-color' => 'Schriftfarbe Neu',
    'areas.products.ribbons.options.gx-ribbon-special-active' => 'Ribbon Angebot anzeigen',
    'areas.products.ribbons.options.gx-ribbon-special-bg' => 'Hintergrundfarbe Angebot',
    'areas.products.ribbons.options.gx-ribbon-special-color' => 'Schriftfarbe Angebot',
    'areas.products.ribbons.options.gx-ribbon-available-active' => 'Ribbon Bald anzeigen',
    'areas.products.ribbons.options.gx-ribbon-available-bg' => 'Hintergrundfarbe Bald',
    'areas.products.ribbons.options.gx-ribbon-available-color' => 'Schriftfarbe Bald',
    'areas.products.ribbons.options.gx-ribbon-recommendation-active' => 'Ribbon Top anzeigen',
    'areas.products.ribbons.options.gx-ribbon-recommendation-bg' => 'Hintergrundfarbe Top',
    'areas.products.ribbons.options.gx-ribbon-recommendation-color' => 'Schriftfarbe Top',
    'areas.products.ribbons.options.gx-ribbon-sold-out-active' => 'Ribbon Ausverkauft anzeigen',
    'areas.products.ribbons.options.gx-ribbon-sold-out-bg' => 'Hintergrundfarbe Ausverkauft',
    'areas.products.ribbons.options.gx-ribbon-sold-out-color' => 'Schriftfarbe Ausverkauft',

    'areas.checkout.title' => 'Checkout',
    'areas.checkout.general.title' => 'Allgemein',
    'areas.checkout.general.gx-checkout-headline-color' => 'Überschriftenfarbe',

    'areas.checkout.shoppingCart.title' => 'Warenkorb',
    'areas.checkout.shoppingCart.options.gx-cart-border-color' => 'Rahmenfarbe',
    'areas.checkout.shoppingCart.options.gx-cart-table-head-color' => 'Schriftfarbe Tabellenkopf',
    'areas.checkout.shoppingCart.options.gx-cart-table-color' => 'Schriftfarbe Tabelle',
    'areas.checkout.shoppingCart.options.gx-cart-table-info-color' => 'Schriftfarbe Produktinformationen',

    'areas.checkout.shoppingCartTotalBox.title' => 'Warenkorb Zusammenfassungs-Box',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-color' => 'Schriftfarbe',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-border-color' => 'Rahmenfarbe',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-top-bg' => 'Hintergrundoben',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-bottom-bg' => 'Hintergrund unten',

    'areas.checkout.checkoutTotalTable.title' => 'Checkout Zusammenfassungs-Tabelle',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-color' => 'Schriftfarbe',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-header-color' => 'Schriftfarbe Header',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-additional-info-color' => 'Schriftfarbe Zusatzinformationen',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-border-color' => 'Rahmenfarbe',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-bg' => 'Hintergrund',

    'areas.checkout.listGroupItems.title' => 'Listenelemente',
    'areas.checkout.listGroupItems.gx-list-group-item-color' => 'Schriftfarbe',
    'areas.checkout.listGroupItems.gx-list-group-item-color-active' => 'Schriftfarbe aktive Auswahl',
    'areas.checkout.listGroupItems.gx-list-group-item-link-color' => 'Linkfarbe',
    'areas.checkout.listGroupItems.gx-list-group-item-link-color-active' => 'Linkfarbe aktive Auswahl',
    'areas.checkout.listGroupItems.gx-list-group-item-border-color' => 'Rahmenfarbe',
    'areas.checkout.listGroupItems.gx-list-group-item-border-color-active' => 'Rahmenfarbe aktive Auswahl',
    'areas.checkout.listGroupItems.gx-list-group-item-bg' => 'Hintergrund',
    'areas.checkout.listGroupItems.gx-list-group-item-bg-active' => 'Hintergrund aktive Auswahl',
    'areas.checkout.listGroupItems.gx-checkout-form-bg' => 'Hintergrund Formular',

    'areas.checkout.checkboxes.title' => 'AGB und Widerruf-Checkboxen',
    'areas.checkout.checkboxes.options.gx-checkbox-color' => 'Textfarbe Checkboxen',
    'areas.checkout.checkboxes.options.gx-checkbox-active-color' => 'Textfarbe Checkboxen Aktiv',
    'areas.checkout.checkboxes.options.gx-checkbox-border' => 'Rahmenfarbe Checkboxen',
    'areas.checkout.checkboxes.options.gx-checkbox-active-border' => 'Rahmenfarbe Checkboxen Aktiv',
    'areas.checkout.checkboxes.options.gx-checkbox-bg' => 'Hintergrund Checkboxen',
    'areas.checkout.checkboxes.options.gx-checkbox-active-bg' => 'Hintergrund Checkboxen Aktiv',

    'areas.menuBoxes.title' => 'Menüboxen',
    'areas.menuBoxes.panelHeader.title' => 'Kopfzeile',
    'areas.menuBoxes.panelHeader.options.gx-panel-header-color' => 'Schriftfarbe',
    'areas.menuBoxes.panelHeader.options.gx-panel-header-bg' => 'Hintergrund',

    'areas.menuBoxes.panelBody.title' => 'Inhaltsbereich',
    'areas.menuBoxes.panelBody.options.gx-panel-bg' => 'Hintergrund',
    'areas.menuBoxes.panelBody.options.gx-panel-border-color' => 'Rahmenfarbe',

    'areas.menuBoxes.activeAt.title' => 'Seiten mit Menüboxspalte',
    'areas.menuBoxes.activeAt.options.gx-index-full-width' => 'Startseite',
    'areas.menuBoxes.activeAt.options.gx-advanced-search-result-full-width' => 'Suchergebnis-Seite',
    'areas.menuBoxes.activeAt.options.gx-shop-content-full-width' => 'Contentmanager Seite',
    'areas.menuBoxes.activeAt.options.gx-product-info-full-width' => 'Artikelseiten',
    'areas.menuBoxes.activeAt.options.gx-product-listing-full-width' => 'Kategorien und Produktlisten',
    'areas.menuBoxes.activeAt.options.gx-shopping-cart-full-width' => 'Warenkorb',
    'areas.menuBoxes.activeAt.options.gx-wishlist-full-width' => 'Merkzettel',
    'areas.menuBoxes.activeAt.options.gx-checkout-full-width' => 'Checkout',
    'areas.menuBoxes.activeAt.options.gx-account-full-width' => 'Kundenkontoseiten',
    'areas.menuBoxes.activeAt.options.gx-create-account-full-width' => 'Kontoerstellung',
    'areas.menuBoxes.activeAt.options.gx-newsletter-full-width' => 'Newsletteranmeldung',
    'areas.menuBoxes.activeAt.options.gx-logoff-full-width' => 'Abmeldeseite',
    'areas.menuBoxesPosition.title' => 'Auswahl und Positionen',
    'areas.menuBoxesPosition.category.title' => 'Kategorien',
    'areas.menuBoxesPosition.filter.title' => 'Filter',
    'areas.menuBoxesPosition.admin.title' => 'Admin',
    'areas.menuBoxesPosition.bestseller.title' => 'Bestseller',
    'areas.menuBoxesPosition.moreAbout.title' => 'Mehr über',
    'areas.menuBoxesPosition.orderHistory.title' => 'Bestellhistorie',
    'areas.menuBoxesPosition.trustedShopsWidget.title' => 'Trusted Shops Widget',
    'areas.menuBoxesPosition.newsletter.title' => 'Newsletter',
    'areas.menuBoxesPosition.specials.title' => 'Angebote',
    'areas.menuBoxesPosition.manufacturer.title' => 'Hersteller',
    'areas.menuBoxesPosition.manufacturerInfo.title' => 'Hersteller Info',
    'areas.menuBoxesPosition.search.title' => 'Suche',
    'areas.menuBoxesPosition.addQuickie.title' => 'Schnellkauf',
    'areas.menuBoxesPosition.whatsNew.title' => 'Neue Artikel',
    'areas.menuBoxesPosition.lastViewed.title' => 'Zuletzt angesehen',
    'areas.menuBoxesPosition.login.title' => 'Kundenlogin',
    'areas.menuBoxesPosition.trustedShops.title' => 'Trusted Shops',
    'areas.menuBoxesPosition.information.title' => 'Informationen',
    'areas.menuBoxesPosition.paypal.title' => 'Paypal',
    'areas.menuBoxesPosition.paypalInstallments.title' => 'Ratenzahlung Powered By PayPal',
    'areas.menuBoxesPosition.ekomi.title' => 'eKomi',
    'areas.menuBoxesPosition.mailbeezShopvoting.title' => 'MailBeez Bewertungen',
    'areas.menuBoxesPosition.extrabox1.title' => 'Zusatzbox 1',
    'areas.menuBoxesPosition.extrabox2.title' => 'Zusatzbox 2',
    'areas.menuBoxesPosition.extrabox3.title' => 'Zusatzbox 3',
    'areas.menuBoxesPosition.extrabox4.title' => 'Zusatzbox 4',
    'areas.menuBoxesPosition.extrabox5.title' => 'Zusatzbox 5',
    'areas.menuBoxesPosition.extrabox6.title' => 'Zusatzbox 6',
    'areas.menuBoxesPosition.extrabox7.title' => 'Zusatzbox 7',
    'areas.menuBoxesPosition.extrabox8.title' => 'Zusatzbox 8',
    'areas.menuBoxesPosition.extrabox9.title' => 'Zusatzbox 9',
    
    /**
     * StyleEdit 4 Widgets
     */
    'areas.styleedit-widgets.title' => 'SE4-Widgets',
    'areas.styleedit-widgets.carousel-widget.title' => 'Carousel',
    'areas.styleedit-widgets.carousel-widget.general' => 'Allgemein',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-text-widget' => 'Textschatten',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-arrow-size' => 'Pfeilgröße',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-arrow-color' => 'Pfeilfarbe',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-arrow-hover-color' => 'Farbe beim Überfahren der Pfeile',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-indicator-size' => 'Indikatorgröße',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-indicator-color' => 'Indikatorfarbe',
    'areas.styleedit-widgets.carousel-widget.options.gx-carousel-widget-indicator-active-color' => 'Farbe des aktiven Indikators',
    'areas.styleedit-widgets.carousel-widget.heading' => 'Überschrift der Bildunterschrift',
    'areas.styleedit-widgets.carousel-widget.heading.gx-carousel-widget-heading-font-size' => 'Schriftgröße',
    'areas.styleedit-widgets.carousel-widget.heading.gx-carousel-widget-heading-font-weight' => 'Überschriftenstärke',
    'areas.styleedit-widgets.carousel-widget.heading.gx-carousel-widget-heading-text-shadow' => 'Textschatten',
    'areas.styleedit-widgets.carousel-widget.heading.gx-carousel-widget-heading-color' => 'Farbe',
    'areas.styleedit-widgets.carousel-widget.tagline' => 'Bildunterschrift Tagline',
    'areas.styleedit-widgets.carousel-widget.tagline.gx-carousel-widget-tagline-font-size' => 'Schriftgröße',
    'areas.styleedit-widgets.carousel-widget.tagline.gx-carousel-widget-tagline-font-weight' => 'Überschriftenstärke',
    'areas.styleedit-widgets.carousel-widget.tagline.gx-carousel-widget-tagline-text-shadow' => 'Textschatten',
    'areas.styleedit-widgets.carousel-widget.tagline.gx-carousel-widget-tagline-color' => 'Farbe',

    'areas.styleedit-widgets.accordion-widget.title' => 'Accordion',
    'areas.styleedit-widgets.accordion-widget.options.general' => 'Allgemein',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-border-radius' => 'Abgerundete Ecken',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-icon-right-padding' => 'Icon richtiger Abstand',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-icon-color' => 'Icon-Farbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-icon-active-color' => 'Aktive Icon-Farbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-border-color' => 'Panel Rahmenfarbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-panels-distance' => 'Panel äußerer Abstand',
    
    'areas.styleedit-widgets.accordion-widget.options.heading' => 'Überschriften',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-padding' => 'Abstand',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-font-size' => 'Schriftgröße',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-font-weight' => 'Überschriftenstärke',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-color' => 'Textfarbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-bg' => 'Hintergrundfarbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-active-color' => 'Aktive Textfarbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-heading-active-bg' => 'Aktive Hintergrundfarbe',
    
    'areas.styleedit-widgets.accordion-widget.options.body' => 'Inhalt',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-body-padding' => 'Abstand',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-body-bg' => 'Hintergrundfarbe',
    'areas.styleedit-widgets.accordion-widget.options.gx-accordion-widget-body-color' => 'Textfarbe',

    // Cookie Consent Panel
    'areas.cookieConsentPanel.title'                                 => 'Cookie Consent Panel',
    'areas.cookieConsentPanel.title.general'                         => 'General',
    'areas.cookieConsentPanel.options.panel.background.color'        => 'Background Color',
    'areas.cookieConsentPanel.options.panel.opacity'                 => 'Opacity',
    'areas.cookieConsentPanel.options.panel.switchers.color'         => 'Switchers Color',
    'areas.cookieConsentPanel.options.panel.buttons.color'           => 'Buttons Color',
    'areas.cookieConsentPanel.options.panel.buttons.color.hover'     => 'Buttons Hover Color',
    'areas.cookieConsentPanel.options.panel.boxshadow'               => 'Box Shadow',
    'areas.cookieConsentPanel.options.panel.headline.font-size'      => 'Headline Font Size',
    'areas.cookieConsentPanel.options.panel.headline.font-family'    => 'Headline Font Family',
    'areas.cookieConsentPanel.options.panel.description.font-size'   => 'Description Font Size',
    'areas.cookieConsentPanel.options.panel.description.font-family' => 'Description Font Family',

    'category' => 'Kategorien',
    'price_min' => 'von',
    'price_max' => 'bis',
    
    'areas.products.productDetailBox.gx-product-info-hide-quantity-input' => 'Mengenfeld ausblenden',

    'areas.general.buttons.general' => 'Allgemein',
    'areas.variants.title' => 'Varianten',
    
    /**
     * HEADER VARIANTS
     */
    'areas.header.variants.default.title' => 'Standard',
    'areas.header.variants.header1.title' => 'Header 1',
    'areas.header.variants.header2.title' => 'Header 2',
    'areas.header.variants.header3.title' => 'Header 3',
    'areas.header.variants.header4.title' => 'Header 4',
    'areas.header.variants.header5.title' => 'Header 5',
    'areas.header.variants.header6.title' => 'Header 6',
    'areas.header.variants.header7.title' => 'Header 7',

    /**
     * TEASER SLIDER VARIANTS
     */
    'areas.slider.title' => 'Teaser-Slider',
    'areas.slider.variants.title' => 'Varianten',
    'areas.slider.variants.default.title' => 'Klassisch',
    'areas.slider.variants.slider1.title' => 'Boxed',
    'areas.slider.variants.slider2.title' => 'Full width',
    'areas.slider.variants.general.title' => 'Allgemein',
    
    /**
     * LAYOUT VARIANTS
     */
    'areas.layout.title' => 'Layout',
    'areas.layout.variants.title' => 'Variants',
    'areas.layout.variants.general.title' => 'Allgemein',
    'areas.layout.variants.bordered.title' => 'Bordered',
    'areas.layout.variants.boxed.title' => 'Boxed',
    'areas.layout.variants.fullscreen.title' => 'Fullscreen',
    'areas.layout.variants.hero.title' => 'Hero',
    'areas.general.layout.options.gx-use-content-zone-for-hero' => 'Content Zone anstelle Slider',
    
    /**
     * PRODUCT PAGE VARIANTS
     */
    'areas.product.title' => 'Produktseite',
    'areas.product.variants.general.title' => 'Allgemein',
    'areas.product.variants.default.title' => 'Links ausrichten',
    'areas.product.variants.classic.title' => 'Klassisch',
    
    "areas.header.general.layout.title" => "Layout",
    "areas.header.general.layout.options.gx-hide-topbar" => "Top-Navigation ausblenden",
    "areas.header.general.layout.options.gx-hide-categories-col" => "Kategorie-Spalte ausblenden",
    "areas.header.general.layout.options.gx-hide-secondary-col" => "Sekundär-Spalte ausblenden",
    
    'areas.header.secondaryCol.title' => 'Sekundär-Spalte',
    'areas.header.secondaryCol.general.title' => 'Allgemein',
    'areas.header.secondaryCol.general.options.gx-secondary-font-size' => 'Schriftgröße',
    'areas.header.secondaryCol.general.options.gx-secondary-height' => 'Höhe',
    'areas.header.secondaryCol.general.options.gx-secondary-height-sticky' => 'Höhe Sticky',
    'areas.header.secondaryCol.general.options.gx-secondary-padding-vertical' => 'Vertikaler Abstand',
    'areas.header.secondaryCol.general.options.gx-secondary-padding-vertical-sticky' => 'Vertikaler Abstand Sticky',
    'areas.header.secondaryCol.general.options.gx-secondary-margin-vertical' => 'Vertikaler äußerer Abstand',
    'areas.header.secondaryCol.general.options.gx-secondary-margin-vertical-sticky' => 'Vertikaler äußerer Abstand Sticky',
    'areas.header.secondaryCol.general.options.gx-secondary-bg' => 'Hintergrund',
    'areas.header.secondaryCol.general.options.gx-secondary-show-icons' => 'Icons anzeigen',
    'areas.header.secondaryCol.general.options.gx-header-secondary-col-sm' => 'Grid-Spalten Klein',
    'areas.header.secondaryCol.general.options.gx-header-secondary-col-md' => 'Grid-Spalten Medium',
    'areas.header.secondaryCol.general.options.gx-header-secondary-col-lg' => 'Grid-Spalten Groß',
    'areas.header.secondaryCol.menuItems.title' => 'Menüpunkte',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-color' => 'Schriftfarbe',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-hover-color' => 'Scriftfarbe Hover',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-active-color' => 'Schriftfarbe Aktiv',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-bg' => 'Hintergrund',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-hover-bg' => 'Hintergrund Hover',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-active-bg' => 'Hintergrund Aktiv',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-padding' => 'Link Abstand',

    'areas.header.secondaryNavigation.title' => 'Sekundärnavigation',
    'areas.header.secondaryNavigation.general.title' => 'Allgemein',
    'areas.header.secondaryNavigation.general.options.gx-secondary-height' => 'Höhe',
    'areas.header.secondaryNavigation.general.options.gx-secondary-height-sticky' => 'Höhe Sticky',

    'areas.header.categoriesCol.title' => 'Kategoriespalte',
    'areas.header.categoriesCol.general.title' => 'Allgemein',
    'areas.header.categoriesCol.general.options.gx-categories-col-height' => 'Höhe',
    'areas.header.categoriesCol.general.options.gx-categories-col-height-sticky' => 'Höhe Sticky',
    'areas.header.categoriesCol.general.options.gx-cart-padding-vertical' => 'Warenkorb Vertikaler Abstand',
    'areas.header.categoriesCol.general.options.gx-cart-padding-vertical-sticky' => 'Warenkorb Vertikaler Abstand Sticky',
    'areas.header.categoriesCol.general.options.gx-cart-margin-vertical' => 'Warenkorb Vertikaler äußerer Abstand',
    'areas.header.categoriesCol.general.options.gx-cart-margin-vertical-sticky' => 'Warenkorb Vertikaler äußerer Abstand Sticky',
    'areas.header.categoriesCol.general.options.gx-header-categories-col-sm' => 'Grid-Spalten Klein',
    'areas.header.categoriesCol.general.options.gx-header-categories-col-md' => 'Grid-Spalten Medium',
    'areas.header.categoriesCol.general.options.gx-header-categories-col-lg' => 'Grid-Spalten Groß',

    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-background-color' => 'Overlay Hintergrundfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-close-icon-color' => 'Schließen-Icon Farbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-close-icon-color-active' => 'Fokussiertes Schließen-Icon Farbe',

    'areas.header.categories.categories-mobile.menu-items' => 'Menüpunkte',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-color' => 'Menüelemente Farbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-background-color' => 'Menüelemente Hintergrundfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-color-active' => 'Aktiver Menüpunkt Farbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-background-color-active' => 'Aktiver Menüpunkt Hintergrundfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-menu-borders-color' => 'Randfarbe',

    'areas.header.categories.categories-mobile.search-form' => 'Suche Form',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-rounded' => 'Abgerundete Ränder',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-text-color' => 'Textfarbe des Suchfelds',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-text-color-active' => 'Fokussierte Suchtextfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-background-color' => 'Hintergrundfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-background-color-active' => 'Fokussierte Hintergrundfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-borders-color' => 'Randfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-borders-color-active' => 'Fokussierte Randfarbe',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-icon-color' => 'Iconfarbe',

    /**
     * PRODUCT MODIFIERS VARIANTS
     */
    'areas.product-modifiers.title' => 'Produkt-Modifikatoren',
    'areas.product-modifiers.square.title' => 'Quadratisch',
    'areas.product-modifiers.rounded.title' => 'Abgerundet',
    'areas.product-modifiers.rounded.border-radius.title' => 'Modifikatoren Grenzradius',
    'areas.product-modifiers.rounded.image' => 'Bild',
    'areas.product-modifiers.rounded.boxed-text' => 'Eingerahmter Text',
    'areas.product-modifiers.rounded.dropdown' => 'Dropdown',
    'areas.product-modifiers.rounded.text' => 'Text',
    'areas.product-modifiers.rounded.radio' => 'Radio',

    /**
     * FOOTER VARIANTS
     */
    'areas.footer.variants.default.title' => 'Default',
    'areas.footer.variants.no-columns.title' => 'No columns',
    'areas.footer.variants.individual.title' => 'Individuell',

    /**
     * AREAS > GENERAL > BUTTONS
     */
    'areas.general.buttons.options.gx-btn-rounded' => 'Abgerundete Buttons',
    'areas.general.buttons.options.gx-btn-borderless' => 'Randlose Buttons',

    'areas.categories.categoriesMobile.options.gx-categories-mobile-height' => 'Höhe',
    'areas.categories.categoriesMobile.options.gx-categories-mobile-icons' => 'Icons anzeigen',
    'areas.categories.categoriesMobile.options.gx-categories-mobile-padding-vertical' => 'Vertikaler Abstand',
    'areas.categories.categoriesMobile.options.navbar-collapse-max-height' => 'Mobil-Menü Höhe',
    'areas.categories.categoriesMobile.title' => 'Kategorien Mobil',
    'areas.categories.general.options.gx-categories-height' => 'Höhe',
    'areas.categories.general.options.gx-categories-height-sticky' => 'Höhe Sticky',
    'areas.categories.general.options.gx-categories-transitions' => 'Übergänge',
    'areas.categories.general.options.navbar-height' => 'Höhe außen',
    'areas.categories.general.options.navbar-margin-bottom' => 'Abstand unten',
    'areas.categories.general.title' => 'Allgemein',
    'areas.categories.megaDropdown.options.gx-categories-tab-padding' => 'Tab-Verschiebung',
    'areas.categories.megaDropdown.options.gx-enter-category-bg' => 'Hintergrund Alle Anzeigen',
    'areas.categories.megaDropdown.options.gx-enter-category-color' => 'Schriftfarbe Alle Anzeigen',
    'areas.categories.megaDropdown.options.gx-megadropdown-bg' => 'Hintergrund',
    'areas.categories.megaDropdown.options.gx-megadropdown-block-count' => 'Anzahl Blöcke',
    'areas.categories.megaDropdown.options.gx-megadropdown-block-width' => 'Block-Breite',
    'areas.categories.megaDropdown.options.gx-megadropdown-color' => 'Schriftfarbe',
    'areas.categories.megaDropdown.options.gx-megadropdown-heading-border-color' => 'Rahmenfarbe',
    'areas.categories.megaDropdown.options.gx-megadropdown-heading-font-size' => 'Schriftgröße Überschriften',
    'areas.categories.megaDropdown.title' => 'Mega-Dropdown',
    'areas.categories.menuItems.options.gx-cat-navbar-bg' => 'Hintergrund',
    'areas.categories.menuItems.options.gx-categories-bg' => 'Hintergrund außen',
    'areas.categories.menuItems.options.gx-categories-headline-size' => 'Schriftgröße',
    'areas.categories.menuItems.options.gx-categories-text-transformation' => 'Texttransformation',
    'areas.categories.menuItems.options.gx-custom-bg-color' => 'Hintergrund Custom',
    'areas.categories.menuItems.options.gx-custom-bg-color-active' => 'Hintergrund Aktiv Custom',
    'areas.categories.menuItems.options.gx-custom-bg-color-hover' => 'Hintergrund Hover Custom',
    'areas.categories.menuItems.options.gx-custom-color' => 'Schriftfarbe Custom',
    'areas.categories.menuItems.options.gx-custom-color-active' => 'Schriftfarbe Aktiv Custom',
    'areas.categories.menuItems.options.gx-custom-color-hover' => 'Schriftfarbe Hover Custom',
    'areas.categories.menuItems.options.navbar-default-link-active-bg' => 'Hintergrund Aktiv',
    'areas.categories.menuItems.options.navbar-default-link-active-color' => 'Schriftfarbe Aktiv',
    'areas.categories.menuItems.options.navbar-default-link-color' => 'Schriftfarbe',
    'areas.categories.menuItems.options.navbar-default-link-hover-bg' => 'Hintergrund Hover',
    'areas.categories.menuItems.options.navbar-default-link-hover-color' => 'Schriftfarbe Hover',
    'areas.categories.menuItems.options.navbar-padding-horizontal' => 'horizontaler Abstand',
    'areas.categories.menuItems.options.navbar-padding-vertical' => 'vertikaler Abstand',
    'areas.categories.menuItems.title' => 'Menüpunkte',
    'areas.categories.title' => 'Kategorien',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-active-color' => 'Schriftfarbe Aktiv',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg' => 'Hintergrund',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg-active' => 'Hintergrund Aktiv',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg-hover' => 'Hintergrund Hover',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg-open' => 'Hintergrund geöffnet',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-color' => 'Schriftfarbe',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-hover-color' => 'Schriftfarbe Hover',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-open-color' => 'Schriftfarbe geöffnet',
    'areas.categories.verticalCategorieMenu.title' => 'Vertikales Kategoriemenü',
    'areas.general.teaserSlider.gx-display-teaser-slider-lg' => 'Teaser-Slider anzeigen Display',
    'areas.general.teaserSlider.gx-display-teaser-slider-md' => 'Teaser-Slider anzeigen Tablet Landscape',
    'areas.general.teaserSlider.gx-display-teaser-slider-sm' => 'Teaser-Slider anzeigen Tablet Portrait',
    'areas.general.teaserSlider.gx-display-teaser-slider-xs' => 'Teaser-Slider anzeigen Mobil',
    'areas.products.productDetailBox.gx-product-info-button-bg' => 'Button Hintergrundfarbe',
    'areas.products.productDetailBox.gx-product-info-button-bg-hover' => 'Button Hintergrundfarbe Hover',
    'areas.products.productDetailBox.gx-product-info-button-border' => 'Button Rahmenfarbe',
    'areas.products.productDetailBox.gx-product-info-button-border-hover' => 'Button Rahmenfarbe Hover',
    'areas.products.productDetailBox.gx-product-info-button-color' => 'Button Schriftfarbe',
    'areas.products.productDetailBox.gx-product-info-button-color-hover' => 'Button Schriftfarbe Hover',
    'areas.products.productDetailBox.gx-product-info-details-bg' => 'Hintergrund',
    'areas.products.productDetailBox.gx-product-info-details-border-color' => 'Rahmenfarbe',
    'areas.products.productDetailBox.gx-product-info-details-border-style' => 'Rahmenstil',
    'areas.products.productDetailBox.gx-product-info-details-border-width' => 'Rahmenbreite',
    'areas.products.productDetailBox.gx-product-info-details-color' => 'Schriftfarbe',
    'areas.products.productDetailBox.gx-product-info-details-note-color' => 'Hinweis Schriftfarbe',
    'areas.products.productDetailBox.gx-product-info-details-sticky' => 'Preisbox mitscrollen',
    'areas.secondaryNavigation.general.options.gx-navbar-topbar-bg' => 'Hintergrund',
    'areas.secondaryNavigation.general.options.gx-navbar-topbar-show-icons' => 'Icons anzeigen',
    'areas.secondaryNavigation.general.options.gx-topbar-font-size' => 'Schriftgröße',
    'areas.secondaryNavigation.general.options.gx-topbar-height' => 'Höhe',
    'areas.secondaryNavigation.general.options.gx-topbar-height-sticky' => 'Höhe Sticky',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-active-bg' => 'Hintergrund Aktiv',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-active-color' => 'Schriftfarbe Aktiv',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-bg' => 'Hintergrund',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-color' => 'Schriftfarbe',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-hover-bg' => 'Hintergrund Hover',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-hover-color' => 'Scriftfarbe Hover',
    'areas.secondaryNavigation.menuItems.options.gx-topbar-link-padding' => 'Link Abstand',
    'areas.secondaryNavigation.menuItems.title' => 'Menüpunkte',
    
];
