'use strict';

/* --------------------------------------------------------------
 modal.js 2016-02-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.theme.modal = jse.libs.theme.modal || {};
jse.libs.theme.modal.magnific = jse.libs.theme.modal.magnific || {};

/**
 * ## Honeygrid Modal Magnific (Library Extension)
 *
 * Library-function to open default modal layer. This function depends on jQuery & jQuery UI.
 *
 * @module Honeygrid/Libs/modal.ext-magnific
 * @exports jse.libs.modal.ext-magnific
 * @ignore
 */
(function (exports) {
    'use strict';

    var $document = $(document),
        $body = $('body');

    var _openLayer = function _openLayer(dataset, deferred, getFormData, originalOptions) {

        var $wrap = null,
            $bg = null,
            $buttons = null,
            $closeX = null,
            $forms = null,
            promise = deferred.promise(),
            instance = null,
            defaults = {
            preloader: false
        },
            options = $.extend({}, defaults, dataset),
            uid = parseInt(Math.random() * 100000);

        // ADD BUTTON INFORMATION
        $.each(options.buttons, function (i, v) {
            options.showButtons = true;
            v.index = i;
            v.uid = uid;
        });

        // GENERATE LAYER
        options.items.src = Mustache.render($('#magnific_wrapper').html(), options);

        $.magnificPopup.open(options);
        instance = $.magnificPopup.instance;

        /**
         * Overwriting the instance previous() and next() methods
         * to prevent the tween effect due to
         * interferences with the swiper module
         */
        instance.prev = function () {
            return instance.content.find('.swiper-button-prev:first').click();
        };
        instance.next = function () {
            return instance.content.find('.swiper-button-next:first').click();
        };

        // GET SELECTIONS
        $wrap = $(instance.wrap);
        $bg = $(instance.bgOverlay);
        $buttons = $wrap.find('.modal-footer button');
        $closeX = $wrap.find('button.mfp-close');

        // ########## EVENT HANDLER ##########

        // REMOVE MAGNIFIC EVENT HANDLER
        $wrap.off('click.mfp');
        $bg.off('click.mfp');
        $document.off('keyup.mfp');

        // BIND BUTTON HANDLER
        $buttons.each(function () {
            var $self = $(this),
                data = $self.data();

            if (typeof data.index === 'number') {
                $self.on('click', dataset.buttons[data.index].event);
            }
        });

        // BIND EVENT HANDLER FOR THE CLOSE BUTTON
        $closeX.off('click').on('click', function (e) {
            e.stopPropagation();
            _rejectHandler($wrap, deferred, getFormData);
        });

        // BIND EVENT HANDLER FOR BACKGROUND LAYER
        if (dataset.closeOnBgClick) {

            $wrap.off('click').on('click', function (e) {
                if (!$(e.target).closest('.modal-dialog').length) {
                    _rejectHandler($wrap, deferred, getFormData);
                }
            });
        }

        // BIND CLOSE HANDLER FOR ESC-KEY
        if (dataset.enableEscapeKey) {

            $document.on('keyup.magnific', function (e) {
                if (e.keyCode === 27) {
                    _rejectHandler($wrap, deferred, getFormData);
                }
            });
        }

        // ADD A CLOSE LAYER METHOD TO THE PROMISE
        // TODO: TESTING
        deferred.close = function (success) {
            if (success) {
                _resolveHandler($wrap, deferred, getFormData);
            } else {
                _rejectHandler($wrap, deferred, getFormData);
            }
        };

        // EXECUTE ADDITIONAL FUNCTION CODE ON LAYER OPEN
        if (options.executeCode && typeof options.executeCode === 'function') {
            options.executeCode.call($wrap);
        }

        if (originalOptions.bootstrapClass !== undefined) {
            $wrap.find('.modal-dialog').addClass(originalOptions.bootstrapClass);
        }

        if (originalOptions.zIndex !== undefined) {
            $wrap.css('z-index', originalOptions.zIndex);
        }

        jse.libs.theme.modal.finalizeLayer($wrap, originalOptions);

        return promise;
    };

    var _convertTheme = function _convertTheme(key, value) {
        var newValue = {
            src: value,
            type: 'inline'
        };

        return ['items', newValue];
    };

    var _getMapper = function _getMapper() {
        return {
            dialogClass: 'mainClass',
            modal: false,
            closeOnEscape: 'enableEscapeKey',
            closeOnOuter: 'closeOnBgClick',
            closeX: 'showCloseBtn',
            storeTheme: false,
            theme: _convertTheme
        };
    };

    var _rejectHandler = function _rejectHandler($element, deferred, getFormData) {
        $element = $element.closest('.mfp-wrap');
        getFormData($element).always(function (result) {
            $document.off('keyup.magnific');
            deferred.reject(result);
            $.magnificPopup.close();
        });
    };

    var _resolveHandler = function _resolveHandler($element, deferred, getFormData) {
        $element = $element.closest('.mfp-wrap');
        getFormData($element, true).done(function (result) {
            $document.off('keyup.magnific');
            deferred.resolve(result);
            $.magnificPopup.close();
        });
    };

    // ########## VARIABLE EXPORT ##########

    exports.openLayer = _openLayer;
    exports.getMapper = _getMapper;
    exports.getResolveHandler = _resolveHandler;
    exports.getRejectHandler = _rejectHandler;
})(jse.libs.theme.modal.magnific);

jse.libs.template.modal = jse.libs.template.modal || {};
jse.libs.template.modal.magnific = jse.libs.theme.modal.magnific;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
