DROP TABLE IF EXISTS `products_properties_combis`;
CREATE TABLE `products_properties_combis` (
	`products_properties_combis_id` int(10) unsigned    NOT NULL AUTO_INCREMENT,
	`products_id`                   int(10) unsigned    NOT NULL DEFAULT '0',
	`sort_order`                    int(10) unsigned    NOT NULL DEFAULT '0',
	`combi_model`                   varchar(64)         NOT NULL DEFAULT '',
	`combi_ean`                     varchar(20)         NOT NULL DEFAULT '',
	`stock_type`                    varchar(16)         NULL     DEFAULT 'not-managed',
	`combi_quantity`                decimal(15, 4)      NOT NULL DEFAULT '0.0000',
	`combi_shipping_status_id`      int(11)             NOT NULL DEFAULT '0',
	`combi_weight`                  decimal(15, 4)      NOT NULL DEFAULT '0.0000',
	`combi_weight_type`             enum ('calc','fix') NULL     DEFAULT NULL,
	`combi_price_type`              enum ('calc','fix') NOT NULL,
	`combi_price`                   decimal(15, 4)      NOT NULL DEFAULT '0.0000',
	`products_vpe_id`               int(11)             NULL     DEFAULT '0',
	`vpe_value`                     decimal(15, 4)      NOT NULL DEFAULT '0.0000',
	`gtin`                          varchar(64)         NULL     DEFAULT NULL,
	`asin`                          varchar(64)         NULL     DEFAULT NULL,
	PRIMARY KEY (`products_properties_combis_id`),
	KEY `products_properties_combis_id`(`products_properties_combis_id`, `products_id`, `sort_order`),
	KEY `products_properties_combis_cheapest`(`products_id` asc, `combi_price` asc),
	KEY `products_id`(`products_id`, `sort_order`)
)
	ENGINE = InnoDB
	DEFAULT CHARSET = `utf8`;

INSERT INTO `products_properties_combis`
VALUES
	(1, 1, 1, 's-gold', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '0.0000', NULL, '0.0000', NULL, NULL),
	(2, 1, 2, 's-red', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '0.0000', NULL, '0.0000', NULL, NULL),
	(3, 1, 3, 's-black', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '1.6807', NULL, '0.0000', NULL, NULL),
	(4, 1, 4, 'm-gold', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '0.0000', NULL, '0.0000', NULL, NULL),
	(5, 1, 5, 'm-red', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '0.0000', NULL, '0.0000', NULL, NULL),
	(6, 1, 6, 'm-black', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '1.6807', NULL, '0.0000', NULL, NULL),
	(7, 1, 7, 'l-gold', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '4.2017', NULL, '0.0000', NULL, NULL),
	(8, 1, 8, 'l-red', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '4.2017', NULL, '0.0000', NULL, NULL),
	(9, 1, 9, 'l-black', '123456789', NULL, '100.0000', 2, '2.0000', NULL, 'calc', '5.8824', NULL, '0.0000', NULL, NULL),
	(10, 3, 1, 'red-36', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(11, 3, 2, 'red-37', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(12, 3, 3, 'red-38', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(13, 3, 4, 'red-39', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(14, 3, 5, 'red-40', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(15, 3, 6, 'red-41', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(16, 3, 7, 'red-42', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(17, 3, 8, 'red-43', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(18, 3, 9, 'red-44', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(19, 3, 10, 'red-45', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(20, 3, 11, 'red-46', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(21, 3, 12, 'gold-36', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(22, 3, 13, 'gold-37', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(23, 3, 14, 'gold-38', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(24, 3, 15, 'gold-39', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(25, 3, 16, 'gold-40', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(26, 3, 17, 'gold-41', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(27, 3, 18, 'gold-42', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(28, 3, 19, 'gold-43', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(29, 3, 20, 'gold-44', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(30, 3, 21, 'gold-45', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(31, 3, 22, 'gold-46', '', NULL, '100.0000', 2, '0.0000', NULL, 'calc', '1.6807', 0, '0.0000', '', ''),
	(32, 4, 1, 'gold', '', NULL, '100.0000', 0, '0.0000', NULL, 'fix', '0.0000', NULL, '0.0000', '', ''),
	(33, 4, 2, 'black', '', NULL, '100.0000', 0, '0.0000', NULL, 'fix', '1.6807', NULL, '0.0000', '', ''),
	(34, 5, 1, 's', '', NULL, '100.0000', 0, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(35, 5, 2, 'm', '', NULL, '100.0000', 0, '0.0000', NULL, 'calc', '0.0000', 0, '0.0000', '', ''),
	(36, 5, 3, 'l', '', NULL, '100.0000', 0, '0.0000', NULL, 'calc', '4.2017', 0, '0.0000', '', '');