<?php
class SofortHtmlTag extends SofortTag {
	
	private static $selfClosingTags = array('base', 'meta', 'link', 'hr', 'br', 'param', 'img', 'area', 'input', 'col');
	
	
	public function __construct($tagname, array $attributes = array(), $children = array()) {
		$tagname = strtolower($tagname);
		$loweredAttributes = array();
		
		foreach ($attributes as $key => $value) {
			$loweredAttributes[strtolower($key)] = $value;
		}
		
		parent::__construct($tagname, $loweredAttributes, $children);
	}
	
	
	protected function _render($output, $attributes) {
		return in_array($this->tagname, self::$selfClosingTags) ? "<{$this->tagname}{$attributes} />" : "<{$this->tagname}{$attributes}>{$output}</{$this->tagname}>";
	}
}
?>