/* properties_delete.js <?php
#   --------------------------------------------------------------
#   properties_delete.js 2018-03-09
#   Gambio GmbH
#   http://www.gambio.de
#   Copyright (c) 2018 Gambio GmbH
#   Released under the GNU General Public License (Version 2)
#   [http://www.gnu.org/licenses/gpl-2.0.html]
#   --------------------------------------------------------------
?>*/

$(document).ready(function () {
    var t_properties_id = t_lightbox_parameters["_" + t_lightbox_identifier]["properties_id"];

    $(".delete", t_lightbox_package).bind("click", delete_propertie);

    function delete_propertie() {
        if ($(this).hasClass("active")) return false;
        $(this).addClass("active");

        $.ajax(
            {
                url: 'request_port.php?module=PropertiesAdmin&action=delete&type=properties&properties_id=' + t_properties_id,
                type: 'GET',
                dataType: 'json',
                error: function (p_jqXHR, p_exception) {
                    $.lightbox_plugin("error", t_lightbox_identifier, p_jqXHR, p_exception);
                },
                success: function (p_response) {
                    if ($.isEmptyObject(p_response)) {
                        $.lightbox_plugin("error", t_lightbox_identifier, "empty_object");
                    } else {
                        $("#properties_table_container_" + p_response.properties_id).remove();
                        $(this).removeClass("active");
                        $.lightbox_plugin("close", t_lightbox_identifier);
                    }
                }
            });
        return false;
    }
});