'use strict';

withdrawals.controllers.module('withdrawals-overview', ['xhr', 'loading_spinner'], function () {
	return {
		vue: true,
		name: 'gx-withdrawals-overview',
		template: '#withdrawals-overview',
		props: ['startupId'],
		data: function data() {
			return {
				page: 1,
				offset: 0,
				limit: 10,
				totalItems: 0,
				totalPages: 1,
				withdrawals: [],
				sortBy: 'id',
				sortOrder: 'desc',
				lang: {
					heading: {
						id: jse.core.lang.translate('label_column_id', 'withdrawals'),
						date: jse.core.lang.translate('label_column_date', 'withdrawals'),
						byAdmin: jse.core.lang.translate('label_column_date_by_admin', 'withdrawals'),
						byCustomer: jse.core.lang.translate('label_column_date_by_customer', 'withdrawals'),
						order: jse.core.lang.translate('label_column_order', 'withdrawals'),
						customer: jse.core.lang.translate('label_column_customer', 'withdrawals')
					},
					limits: {
						10: jse.core.lang.translate('option_limits_10', 'withdrawals'),
						25: jse.core.lang.translate('option_limits_25', 'withdrawals'),
						50: jse.core.lang.translate('option_limits_50', 'withdrawals'),
						100: jse.core.lang.translate('option_limits_100', 'withdrawals')
					},
					offset: {
						of: jse.core.lang.translate('label_offset_of', 'withdrawals'),
						to: jse.core.lang.translate('label_offset_to', 'withdrawals')
					},
					page: {
						previous: jse.core.lang.translate('label_page_previous', 'withdrawals'),
						next: jse.core.lang.translate('label_page_next', 'withdrawals')
					},
					noWithdrawalsExist: jse.core.lang.translate('no_withdrawals_exist', 'withdrawals'),
					create: jse.core.lang.translate('create', 'buttons')
				},
				detailsWithdrawalId: undefined,
				deleteWithdrawal: undefined
			};
		},
		methods: {
			loadWithdrawals: function loadWithdrawals() {
				if (this.startupId !== '' && Number.isInteger(parseInt(this.startupId))) {
					this.detailsWithdrawalId = parseInt(this.startupId);
				}

				var vm = this;
				var $target = $('table.withdrawals');
				var spinner = jse.libs.loading_spinner.show($target);

				jse.libs.xhr.post({
					url: './admin.php?do=Withdrawals/GetWithdrawals',
					data: {
						limit: this.limit,
						offset: this.offset,
						sortOrder: this.sortOrder,
						sortBy: this.sortBy
					}
				}).done(function (response) {
					vm.withdrawals = response.withdrawals;
					vm.totalItems = response.total;
					vm.totalPages = Math.ceil(vm.totalItems / vm.limit);
					jse.libs.loading_spinner.hide(spinner);
				}).fail(function (response) {
					console.error('Could not load withdrawals.', response);
					jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_load_withdrawals', 'withdrawals'));
					jse.libs.loading_spinner.hide(spinner);
					vm.withdrawals = [];
					vm.totalItems = 0;
					vm.totalPages = 1;
				});
			},
			changeSorting: function changeSorting(column) {
				this.sortOrder = this.sortBy !== column ? 'desc' : this.sortOrder === 'desc' ? 'asc' : 'desc';
				this.sortBy = column;

				this.loadWithdrawals();
			},
			previousPage: function previousPage() {
				this.page = this.page === 1 ? 1 : this.page - 1;
				this.updateOffset();
				this.loadWithdrawals();
			},
			updateOffset: function updateOffset() {
				this.offset = (this.page - 1) * this.limit;
			},
			nextPage: function nextPage() {
				this.page = this.page === this.totalPages ? this.totalPages : this.page + 1;
				this.updateOffset();
				this.loadWithdrawals();
			},
			openCreateModal: function openCreateModal() {
				$('.create-modal.modal').modal('show');
			},
			openDetailsModal: function openDetailsModal(id) {
				var _this = this;

				this.detailsWithdrawalId = id;
				var $modal = $('.details-modal.modal');
				$modal.on('hidden.bs.modal', function () {
					_this.detailsWithdrawalId = undefined;
				});
			},
			openDeleteModal: function openDeleteModal(withdrawal) {
				var _this2 = this;

				this.deleteWithdrawal = withdrawal;
				var $modal = $('.delete-modal.modal');
				$modal.on('hidden.bs.modal', function () {
					_this2.deleteWithdrawal = undefined;
				});
			}
		},
		mounted: function mounted() {
			this.loadWithdrawals();
		},

		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpdGhkcmF3YWxzL3dpdGhkcmF3YWxzLW92ZXJ2aWV3LmpzIl0sIm5hbWVzIjpbIndpdGhkcmF3YWxzIiwiY29udHJvbGxlcnMiLCJtb2R1bGUiLCJ2dWUiLCJuYW1lIiwidGVtcGxhdGUiLCJwcm9wcyIsImRhdGEiLCJwYWdlIiwib2Zmc2V0IiwibGltaXQiLCJ0b3RhbEl0ZW1zIiwidG90YWxQYWdlcyIsInNvcnRCeSIsInNvcnRPcmRlciIsImxhbmciLCJoZWFkaW5nIiwiaWQiLCJqc2UiLCJjb3JlIiwidHJhbnNsYXRlIiwiZGF0ZSIsImJ5QWRtaW4iLCJieUN1c3RvbWVyIiwib3JkZXIiLCJjdXN0b21lciIsImxpbWl0cyIsIm9mIiwidG8iLCJwcmV2aW91cyIsIm5leHQiLCJub1dpdGhkcmF3YWxzRXhpc3QiLCJjcmVhdGUiLCJkZXRhaWxzV2l0aGRyYXdhbElkIiwidW5kZWZpbmVkIiwiZGVsZXRlV2l0aGRyYXdhbCIsIm1ldGhvZHMiLCJsb2FkV2l0aGRyYXdhbHMiLCJzdGFydHVwSWQiLCJOdW1iZXIiLCJpc0ludGVnZXIiLCJwYXJzZUludCIsInZtIiwiJHRhcmdldCIsIiQiLCJzcGlubmVyIiwibGlicyIsImxvYWRpbmdfc3Bpbm5lciIsInNob3ciLCJ4aHIiLCJwb3N0IiwidXJsIiwiZG9uZSIsInJlc3BvbnNlIiwidG90YWwiLCJNYXRoIiwiY2VpbCIsImhpZGUiLCJmYWlsIiwiY29uc29sZSIsImVycm9yIiwiaW5mb19tZXNzYWdlcyIsImFkZEVycm9yIiwiY2hhbmdlU29ydGluZyIsImNvbHVtbiIsInByZXZpb3VzUGFnZSIsInVwZGF0ZU9mZnNldCIsIm5leHRQYWdlIiwib3BlbkNyZWF0ZU1vZGFsIiwibW9kYWwiLCJvcGVuRGV0YWlsc01vZGFsIiwiJG1vZGFsIiwib24iLCJvcGVuRGVsZXRlTW9kYWwiLCJ3aXRoZHJhd2FsIiwibW91bnRlZCIsImluaXQiXSwibWFwcGluZ3MiOiI7O0FBQUFBLFlBQVlDLFdBQVosQ0FBd0JDLE1BQXhCLENBQStCLHNCQUEvQixFQUNDLENBQUMsS0FBRCxFQUFRLGlCQUFSLENBREQsRUFFQyxZQUFNO0FBQ0wsUUFBTztBQUNOQyxPQUFLLElBREM7QUFFTkMsUUFBTSx5QkFGQTtBQUdOQyxZQUFVLHVCQUhKO0FBSU5DLFNBQU8sQ0FBQyxXQUFELENBSkQ7QUFLTkMsUUFBTTtBQUFBLFVBQU87QUFDWkMsVUFBTSxDQURNO0FBRVpDLFlBQVEsQ0FGSTtBQUdaQyxXQUFPLEVBSEs7QUFJWkMsZ0JBQVksQ0FKQTtBQUtaQyxnQkFBWSxDQUxBO0FBTVpaLGlCQUFhLEVBTkQ7QUFPWmEsWUFBUSxJQVBJO0FBUVpDLGVBQVcsTUFSQztBQVNaQyxVQUFNO0FBQ0xDLGNBQVM7QUFDUkMsVUFBSUMsSUFBSUMsSUFBSixDQUFTSixJQUFULENBQWNLLFNBQWQsQ0FBd0IsaUJBQXhCLEVBQTJDLGFBQTNDLENBREk7QUFFUkMsWUFBTUgsSUFBSUMsSUFBSixDQUFTSixJQUFULENBQWNLLFNBQWQsQ0FBd0IsbUJBQXhCLEVBQTZDLGFBQTdDLENBRkU7QUFHUkUsZUFBU0osSUFBSUMsSUFBSixDQUFTSixJQUFULENBQWNLLFNBQWQsQ0FBd0IsNEJBQXhCLEVBQXNELGFBQXRELENBSEQ7QUFJUkcsa0JBQVlMLElBQUlDLElBQUosQ0FBU0osSUFBVCxDQUFjSyxTQUFkLENBQXdCLCtCQUF4QixFQUF5RCxhQUF6RCxDQUpKO0FBS1JJLGFBQU9OLElBQUlDLElBQUosQ0FBU0osSUFBVCxDQUFjSyxTQUFkLENBQXdCLG9CQUF4QixFQUE4QyxhQUE5QyxDQUxDO0FBTVJLLGdCQUFVUCxJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3Qix1QkFBeEIsRUFBaUQsYUFBakQ7QUFORixNQURKO0FBU0xNLGFBQVE7QUFDUCxVQUFJUixJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3QixrQkFBeEIsRUFBNEMsYUFBNUMsQ0FERztBQUVQLFVBQUlGLElBQUlDLElBQUosQ0FBU0osSUFBVCxDQUFjSyxTQUFkLENBQXdCLGtCQUF4QixFQUE0QyxhQUE1QyxDQUZHO0FBR1AsVUFBSUYsSUFBSUMsSUFBSixDQUFTSixJQUFULENBQWNLLFNBQWQsQ0FBd0Isa0JBQXhCLEVBQTRDLGFBQTVDLENBSEc7QUFJUCxXQUFLRixJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3QixtQkFBeEIsRUFBNkMsYUFBN0M7QUFKRSxNQVRIO0FBZUxYLGFBQVE7QUFDUGtCLFVBQUlULElBQUlDLElBQUosQ0FBU0osSUFBVCxDQUFjSyxTQUFkLENBQXdCLGlCQUF4QixFQUEyQyxhQUEzQyxDQURHO0FBRVBRLFVBQUlWLElBQUlDLElBQUosQ0FBU0osSUFBVCxDQUFjSyxTQUFkLENBQXdCLGlCQUF4QixFQUEyQyxhQUEzQztBQUZHLE1BZkg7QUFtQkxaLFdBQU07QUFDTHFCLGdCQUFVWCxJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3QixxQkFBeEIsRUFBK0MsYUFBL0MsQ0FETDtBQUVMVSxZQUFNWixJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3QixpQkFBeEIsRUFBMkMsYUFBM0M7QUFGRCxNQW5CRDtBQXVCTFcseUJBQW9CYixJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3QixzQkFBeEIsRUFBZ0QsYUFBaEQsQ0F2QmY7QUF3QkxZLGFBQVFkLElBQUlDLElBQUosQ0FBU0osSUFBVCxDQUFjSyxTQUFkLENBQXdCLFFBQXhCLEVBQWtDLFNBQWxDO0FBeEJILEtBVE07QUFtQ1phLHlCQUFxQkMsU0FuQ1Q7QUFvQ1pDLHNCQUFrQkQ7QUFwQ04sSUFBUDtBQUFBLEdBTEE7QUEyQ05FLFdBQVM7QUFDUkMsa0JBRFEsNkJBQ1U7QUFDakIsUUFBRyxLQUFLQyxTQUFMLEtBQW1CLEVBQW5CLElBQXlCQyxPQUFPQyxTQUFQLENBQWlCQyxTQUFTLEtBQUtILFNBQWQsQ0FBakIsQ0FBNUIsRUFBdUU7QUFDdEUsVUFBS0wsbUJBQUwsR0FBMkJRLFNBQVMsS0FBS0gsU0FBZCxDQUEzQjtBQUNBOztBQUVELFFBQU1JLEtBQUssSUFBWDtBQUNBLFFBQU1DLFVBQVVDLEVBQUUsbUJBQUYsQ0FBaEI7QUFDQSxRQUFNQyxVQUFVM0IsSUFBSTRCLElBQUosQ0FBU0MsZUFBVCxDQUF5QkMsSUFBekIsQ0FBOEJMLE9BQTlCLENBQWhCOztBQUVBekIsUUFBSTRCLElBQUosQ0FBU0csR0FBVCxDQUFhQyxJQUFiLENBQWtCO0FBQ2pCQyxVQUFLLDJDQURZO0FBRWpCNUMsV0FBTTtBQUNMRyxhQUFPLEtBQUtBLEtBRFA7QUFFTEQsY0FBUSxLQUFLQSxNQUZSO0FBR0xLLGlCQUFXLEtBQUtBLFNBSFg7QUFJTEQsY0FBUSxLQUFLQTtBQUpSO0FBRlcsS0FBbEIsRUFRR3VDLElBUkgsQ0FRUSxvQkFBWTtBQUNuQlYsUUFBRzFDLFdBQUgsR0FBaUJxRCxTQUFTckQsV0FBMUI7QUFDQTBDLFFBQUcvQixVQUFILEdBQWdCMEMsU0FBU0MsS0FBekI7QUFDQVosUUFBRzlCLFVBQUgsR0FBZ0IyQyxLQUFLQyxJQUFMLENBQVVkLEdBQUcvQixVQUFILEdBQWdCK0IsR0FBR2hDLEtBQTdCLENBQWhCO0FBQ0FRLFNBQUk0QixJQUFKLENBQVNDLGVBQVQsQ0FBeUJVLElBQXpCLENBQThCWixPQUE5QjtBQUNBLEtBYkQsRUFhR2EsSUFiSCxDQWFRLFVBQUNMLFFBQUQsRUFBYztBQUNyQk0sYUFBUUMsS0FBUixDQUFjLDZCQUFkLEVBQTZDUCxRQUE3QztBQUNBbkMsU0FBSTRCLElBQUosQ0FBU2UsYUFBVCxDQUF1QkMsUUFBdkIsQ0FBZ0M1QyxJQUFJQyxJQUFKLENBQVNKLElBQVQsQ0FBY0ssU0FBZCxDQUF3QixrQ0FBeEIsRUFBNEQsYUFBNUQsQ0FBaEM7QUFDQUYsU0FBSTRCLElBQUosQ0FBU0MsZUFBVCxDQUF5QlUsSUFBekIsQ0FBOEJaLE9BQTlCO0FBQ0FILFFBQUcxQyxXQUFILEdBQWlCLEVBQWpCO0FBQ0EwQyxRQUFHL0IsVUFBSCxHQUFnQixDQUFoQjtBQUNBK0IsUUFBRzlCLFVBQUgsR0FBZ0IsQ0FBaEI7QUFDQSxLQXBCRDtBQXFCQSxJQS9CTztBQWdDUm1ELGdCQWhDUSx5QkFnQ01DLE1BaENOLEVBZ0NjO0FBQ3JCLFNBQUtsRCxTQUFMLEdBQWtCLEtBQUtELE1BQUwsS0FBZ0JtRCxNQUFqQixHQUEwQixNQUExQixHQUFvQyxLQUFLbEQsU0FBTCxLQUFtQixNQUFuQixHQUEyQixLQUEzQixHQUFtQyxNQUF4RjtBQUNBLFNBQUtELE1BQUwsR0FBY21ELE1BQWQ7O0FBRUEsU0FBSzNCLGVBQUw7QUFDQSxJQXJDTztBQXNDUjRCLGVBdENRLDBCQXNDTztBQUNkLFNBQUt6RCxJQUFMLEdBQVksS0FBS0EsSUFBTCxLQUFjLENBQWQsR0FBa0IsQ0FBbEIsR0FBc0IsS0FBS0EsSUFBTCxHQUFZLENBQTlDO0FBQ0EsU0FBSzBELFlBQUw7QUFDQSxTQUFLN0IsZUFBTDtBQUNBLElBMUNPO0FBMkNSNkIsZUEzQ1EsMEJBMkNPO0FBQ2QsU0FBS3pELE1BQUwsR0FBYyxDQUFDLEtBQUtELElBQUwsR0FBWSxDQUFiLElBQWtCLEtBQUtFLEtBQXJDO0FBQ0EsSUE3Q087QUE4Q1J5RCxXQTlDUSxzQkE4Q0c7QUFDVixTQUFLM0QsSUFBTCxHQUFZLEtBQUtBLElBQUwsS0FBYyxLQUFLSSxVQUFuQixHQUFnQyxLQUFLQSxVQUFyQyxHQUFrRCxLQUFLSixJQUFMLEdBQVksQ0FBMUU7QUFDQSxTQUFLMEQsWUFBTDtBQUNBLFNBQUs3QixlQUFMO0FBQ0EsSUFsRE87QUFtRFIrQixrQkFuRFEsNkJBbURVO0FBQ2pCeEIsTUFBRSxxQkFBRixFQUF5QnlCLEtBQXpCLENBQStCLE1BQS9CO0FBQ0EsSUFyRE87QUFzRFJDLG1CQXREUSw0QkFzRFNyRCxFQXREVCxFQXNEYTtBQUFBOztBQUNwQixTQUFLZ0IsbUJBQUwsR0FBMkJoQixFQUEzQjtBQUNBLFFBQU1zRCxTQUFTM0IsRUFBRSxzQkFBRixDQUFmO0FBQ0EyQixXQUFPQyxFQUFQLENBQVUsaUJBQVYsRUFBNkIsWUFBTTtBQUNsQyxXQUFLdkMsbUJBQUwsR0FBMkJDLFNBQTNCO0FBQ0EsS0FGRDtBQUdBLElBNURPO0FBNkRSdUMsa0JBN0RRLDJCQTZEUUMsVUE3RFIsRUE2RG9CO0FBQUE7O0FBQzNCLFNBQUt2QyxnQkFBTCxHQUF3QnVDLFVBQXhCO0FBQ0EsUUFBTUgsU0FBUzNCLEVBQUUscUJBQUYsQ0FBZjtBQUNBMkIsV0FBT0MsRUFBUCxDQUFVLGlCQUFWLEVBQTZCLFlBQU07QUFDbEMsWUFBS3JDLGdCQUFMLEdBQXdCRCxTQUF4QjtBQUNBLEtBRkQ7QUFHQTtBQW5FTyxHQTNDSDtBQWdITnlDLFNBaEhNLHFCQWdISTtBQUNULFFBQUt0QyxlQUFMO0FBQ0EsR0FsSEs7O0FBbUhOdUMsUUFBTTtBQUFBLFVBQVF4QixNQUFSO0FBQUE7QUFuSEEsRUFBUDtBQXFIQSxDQXhIRiIsImZpbGUiOiJ3aXRoZHJhd2Fscy93aXRoZHJhd2Fscy1vdmVydmlldy5qcyIsInNvdXJjZXNDb250ZW50IjpbIndpdGhkcmF3YWxzLmNvbnRyb2xsZXJzLm1vZHVsZSgnd2l0aGRyYXdhbHMtb3ZlcnZpZXcnLFxuXHRbJ3hocicsICdsb2FkaW5nX3NwaW5uZXInXSxcblx0KCkgPT4ge1xuXHRcdHJldHVybiB7XG5cdFx0XHR2dWU6IHRydWUsXG5cdFx0XHRuYW1lOiAnZ3gtd2l0aGRyYXdhbHMtb3ZlcnZpZXcnLFxuXHRcdFx0dGVtcGxhdGU6ICcjd2l0aGRyYXdhbHMtb3ZlcnZpZXcnLFxuXHRcdFx0cHJvcHM6IFsnc3RhcnR1cElkJ10sXG5cdFx0XHRkYXRhOiAoKSA9PiAoe1xuXHRcdFx0XHRwYWdlOiAxLFxuXHRcdFx0XHRvZmZzZXQ6IDAsXG5cdFx0XHRcdGxpbWl0OiAxMCxcblx0XHRcdFx0dG90YWxJdGVtczogMCxcblx0XHRcdFx0dG90YWxQYWdlczogMSxcblx0XHRcdFx0d2l0aGRyYXdhbHM6IFtdLFxuXHRcdFx0XHRzb3J0Qnk6ICdpZCcsXG5cdFx0XHRcdHNvcnRPcmRlcjogJ2Rlc2MnLFxuXHRcdFx0XHRsYW5nOiB7XG5cdFx0XHRcdFx0aGVhZGluZzoge1xuXHRcdFx0XHRcdFx0aWQ6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdsYWJlbF9jb2x1bW5faWQnLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRcdGRhdGU6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdsYWJlbF9jb2x1bW5fZGF0ZScsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdFx0YnlBZG1pbjoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX2NvbHVtbl9kYXRlX2J5X2FkbWluJywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0XHRieUN1c3RvbWVyOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnbGFiZWxfY29sdW1uX2RhdGVfYnlfY3VzdG9tZXInLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRcdG9yZGVyOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnbGFiZWxfY29sdW1uX29yZGVyJywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0XHRjdXN0b21lcjoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX2NvbHVtbl9jdXN0b21lcicsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0bGltaXRzOiB7XG5cdFx0XHRcdFx0XHQxMDoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ29wdGlvbl9saW1pdHNfMTAnLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRcdDI1OiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnb3B0aW9uX2xpbWl0c18yNScsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdFx0NTA6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdvcHRpb25fbGltaXRzXzUwJywgJ3dpdGhkcmF3YWxzJyksXG5cdFx0XHRcdFx0XHQxMDA6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdvcHRpb25fbGltaXRzXzEwMCcsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0b2Zmc2V0OiB7XG5cdFx0XHRcdFx0XHRvZjoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX29mZnNldF9vZicsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdFx0dG86IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdsYWJlbF9vZmZzZXRfdG8nLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdHBhZ2U6IHtcblx0XHRcdFx0XHRcdHByZXZpb3VzOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnbGFiZWxfcGFnZV9wcmV2aW91cycsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdFx0bmV4dDoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX3BhZ2VfbmV4dCcsICd3aXRoZHJhd2FscycpLFxuXHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0bm9XaXRoZHJhd2Fsc0V4aXN0OiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnbm9fd2l0aGRyYXdhbHNfZXhpc3QnLCAnd2l0aGRyYXdhbHMnKSxcblx0XHRcdFx0XHRjcmVhdGU6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdjcmVhdGUnLCAnYnV0dG9ucycpLFxuXHRcdFx0XHR9LFxuXHRcdFx0XHRkZXRhaWxzV2l0aGRyYXdhbElkOiB1bmRlZmluZWQsXG5cdFx0XHRcdGRlbGV0ZVdpdGhkcmF3YWw6IHVuZGVmaW5lZCxcblx0XHRcdH0pLFxuXHRcdFx0bWV0aG9kczoge1xuXHRcdFx0XHRsb2FkV2l0aGRyYXdhbHMoKSB7XG5cdFx0XHRcdFx0aWYodGhpcy5zdGFydHVwSWQgIT09ICcnICYmIE51bWJlci5pc0ludGVnZXIocGFyc2VJbnQodGhpcy5zdGFydHVwSWQpKSl7XG5cdFx0XHRcdFx0XHR0aGlzLmRldGFpbHNXaXRoZHJhd2FsSWQgPSBwYXJzZUludCh0aGlzLnN0YXJ0dXBJZCk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdFxuXHRcdFx0XHRcdGNvbnN0IHZtID0gdGhpcztcblx0XHRcdFx0XHRjb25zdCAkdGFyZ2V0ID0gJCgndGFibGUud2l0aGRyYXdhbHMnKTtcblx0XHRcdFx0XHRjb25zdCBzcGlubmVyID0ganNlLmxpYnMubG9hZGluZ19zcGlubmVyLnNob3coJHRhcmdldCk7XG5cdFx0XHRcdFx0XG5cdFx0XHRcdFx0anNlLmxpYnMueGhyLnBvc3Qoe1xuXHRcdFx0XHRcdFx0dXJsOiAnLi9hZG1pbi5waHA/ZG89V2l0aGRyYXdhbHMvR2V0V2l0aGRyYXdhbHMnLFxuXHRcdFx0XHRcdFx0ZGF0YToge1xuXHRcdFx0XHRcdFx0XHRsaW1pdDogdGhpcy5saW1pdCxcblx0XHRcdFx0XHRcdFx0b2Zmc2V0OiB0aGlzLm9mZnNldCxcblx0XHRcdFx0XHRcdFx0c29ydE9yZGVyOiB0aGlzLnNvcnRPcmRlcixcblx0XHRcdFx0XHRcdFx0c29ydEJ5OiB0aGlzLnNvcnRCeSxcblx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHR9KS5kb25lKHJlc3BvbnNlID0+IHtcblx0XHRcdFx0XHRcdHZtLndpdGhkcmF3YWxzID0gcmVzcG9uc2Uud2l0aGRyYXdhbHM7XG5cdFx0XHRcdFx0XHR2bS50b3RhbEl0ZW1zID0gcmVzcG9uc2UudG90YWw7XG5cdFx0XHRcdFx0XHR2bS50b3RhbFBhZ2VzID0gTWF0aC5jZWlsKHZtLnRvdGFsSXRlbXMgLyB2bS5saW1pdCk7XG5cdFx0XHRcdFx0XHRqc2UubGlicy5sb2FkaW5nX3NwaW5uZXIuaGlkZShzcGlubmVyKTtcblx0XHRcdFx0XHR9KS5mYWlsKChyZXNwb25zZSkgPT4ge1xuXHRcdFx0XHRcdFx0Y29uc29sZS5lcnJvcignQ291bGQgbm90IGxvYWQgd2l0aGRyYXdhbHMuJywgcmVzcG9uc2UpO1xuXHRcdFx0XHRcdFx0anNlLmxpYnMuaW5mb19tZXNzYWdlcy5hZGRFcnJvcihqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZXJyb3JfY291bGRfbm90X2xvYWRfd2l0aGRyYXdhbHMnLCAnd2l0aGRyYXdhbHMnKSk7XG5cdFx0XHRcdFx0XHRqc2UubGlicy5sb2FkaW5nX3NwaW5uZXIuaGlkZShzcGlubmVyKTtcblx0XHRcdFx0XHRcdHZtLndpdGhkcmF3YWxzID0gW107XG5cdFx0XHRcdFx0XHR2bS50b3RhbEl0ZW1zID0gMDtcblx0XHRcdFx0XHRcdHZtLnRvdGFsUGFnZXMgPSAxO1xuXHRcdFx0XHRcdH0pO1xuXHRcdFx0XHR9LFxuXHRcdFx0XHRjaGFuZ2VTb3J0aW5nKGNvbHVtbikge1xuXHRcdFx0XHRcdHRoaXMuc29ydE9yZGVyID0gKHRoaXMuc29ydEJ5ICE9PSBjb2x1bW4pPyAnZGVzYycgOiAodGhpcy5zb3J0T3JkZXIgPT09ICdkZXNjJz8gJ2FzYycgOiAnZGVzYycpO1xuXHRcdFx0XHRcdHRoaXMuc29ydEJ5ID0gY29sdW1uO1xuXHRcdFx0XHRcdFxuXHRcdFx0XHRcdHRoaXMubG9hZFdpdGhkcmF3YWxzKCk7XG5cdFx0XHRcdH0sXG5cdFx0XHRcdHByZXZpb3VzUGFnZSgpIHtcblx0XHRcdFx0XHR0aGlzLnBhZ2UgPSB0aGlzLnBhZ2UgPT09IDEgPyAxIDogdGhpcy5wYWdlIC0gMTtcblx0XHRcdFx0XHR0aGlzLnVwZGF0ZU9mZnNldCgpO1xuXHRcdFx0XHRcdHRoaXMubG9hZFdpdGhkcmF3YWxzKCk7XG5cdFx0XHRcdH0sXG5cdFx0XHRcdHVwZGF0ZU9mZnNldCgpIHtcblx0XHRcdFx0XHR0aGlzLm9mZnNldCA9ICh0aGlzLnBhZ2UgLSAxKSAqIHRoaXMubGltaXQ7XG5cdFx0XHRcdH0sXG5cdFx0XHRcdG5leHRQYWdlKCkge1xuXHRcdFx0XHRcdHRoaXMucGFnZSA9IHRoaXMucGFnZSA9PT0gdGhpcy50b3RhbFBhZ2VzID8gdGhpcy50b3RhbFBhZ2VzIDogdGhpcy5wYWdlICsgMTtcblx0XHRcdFx0XHR0aGlzLnVwZGF0ZU9mZnNldCgpO1xuXHRcdFx0XHRcdHRoaXMubG9hZFdpdGhkcmF3YWxzKCk7XG5cdFx0XHRcdH0sXG5cdFx0XHRcdG9wZW5DcmVhdGVNb2RhbCgpIHtcblx0XHRcdFx0XHQkKCcuY3JlYXRlLW1vZGFsLm1vZGFsJykubW9kYWwoJ3Nob3cnKTtcblx0XHRcdFx0fSxcblx0XHRcdFx0b3BlbkRldGFpbHNNb2RhbChpZCkge1xuXHRcdFx0XHRcdHRoaXMuZGV0YWlsc1dpdGhkcmF3YWxJZCA9IGlkO1xuXHRcdFx0XHRcdGNvbnN0ICRtb2RhbCA9ICQoJy5kZXRhaWxzLW1vZGFsLm1vZGFsJyk7XG5cdFx0XHRcdFx0JG1vZGFsLm9uKCdoaWRkZW4uYnMubW9kYWwnLCAoKSA9PiB7XG5cdFx0XHRcdFx0XHR0aGlzLmRldGFpbHNXaXRoZHJhd2FsSWQgPSB1bmRlZmluZWQ7XG5cdFx0XHRcdFx0fSk7XG5cdFx0XHRcdH0sXG5cdFx0XHRcdG9wZW5EZWxldGVNb2RhbCh3aXRoZHJhd2FsKSB7XG5cdFx0XHRcdFx0dGhpcy5kZWxldGVXaXRoZHJhd2FsID0gd2l0aGRyYXdhbDtcblx0XHRcdFx0XHRjb25zdCAkbW9kYWwgPSAkKCcuZGVsZXRlLW1vZGFsLm1vZGFsJyk7XG5cdFx0XHRcdFx0JG1vZGFsLm9uKCdoaWRkZW4uYnMubW9kYWwnLCAoKSA9PiB7XG5cdFx0XHRcdFx0XHR0aGlzLmRlbGV0ZVdpdGhkcmF3YWwgPSB1bmRlZmluZWQ7XG5cdFx0XHRcdFx0fSk7XG5cdFx0XHRcdH0sXG5cdFx0XHR9LFxuXHRcdFx0bW91bnRlZCgpIHtcblx0XHRcdFx0dGhpcy5sb2FkV2l0aGRyYXdhbHMoKTtcblx0XHRcdH0sXG5cdFx0XHRpbml0OiBkb25lID0+IGRvbmUoKVxuXHRcdH1cblx0fSk7Il19
