'use strict';

parcel_services.controllers.module('delete-modal', ['xhr', gx.source + '/libs/info_messages'], function () {
	return {
		vue: true,
		name: 'gx-delete-modal',
		template: '#delete-modal',
		parent: 'gx-parcel-services-overview',
		props: ['details'],
		data: function data() {
			return {
				lang: {
					title: jse.core.lang.translate('delete_modal_title', 'parcel_services'),
					close: jse.core.lang.translate('cancel', 'buttons'),
					confirm: jse.core.lang.translate('delete', 'buttons'),
					labels: {
						text: jse.core.lang.translate('delete_modal_text', 'parcel_services'),
						name: jse.core.lang.translate('label_name', 'parcel_services')
					}
				}
			};
		},
		methods: {
			confirm: function confirm() {
				var _this = this;

				jse.libs.xhr.delete({
					url: './api/parcel-services/' + this.details.id
				}).done(function (response) {
					_this.$emit('reload-overview');
				}).fail(function (response) {
					console.error('Could not delete parcel service.', response);
					jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_delete_parcel_service', 'parcel_services'));
				});
				$('.delete-modal.modal').modal('hide');
			},
			openModal: function openModal(deleteDetails) {
				this.details = deleteDetails;
				$('.delete-modal.modal').modal('show');
			}
		},
		created: function created() {},

		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
