'use strict';

/* --------------------------------------------------------------
 shortcuts.js 2015-09-23 gm
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Keyboard Shortcuts
 *
 * Allows to assign shortcuts for different actions.
 *
 * @module Compatibility/shortcuts
 */
gx.compatibility.module(
// Module name
'shortcuts',

// Module dependencies
[],

/**  @lends module:Compatibility/shortcuts */

function () {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var keysPressed = [],
        module = {};

    // ------------------------------------------------------------------------
    // ELEMENTS DEFINITION
    // ------------------------------------------------------------------------

    var $adminSearchInput = $('input[name="admin_search"]'),
        $favoriteMenuItems = $('#BOX_HEADING_FAVORITES > li');

    // ------------------------------------------------------------------------
    // MAPS
    // ------------------------------------------------------------------------

    var keyMap = {

        ctrl: 17,
        shift: 16,

        f: 70,

        normal1: 49,
        normal2: 50,
        normal3: 51,
        normal4: 52,
        normal5: 53,
        normal6: 54,
        normal7: 55,
        normal8: 56,
        normal9: 57

    };

    var shortcutMap = {

        activateSearch: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.f],
            performAction: function performAction() {
                $adminSearchInput.trigger('click');
            }
        },

        openFavorite1: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal1],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(0);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite2: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal2],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(1);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite3: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal3],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(2);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite4: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal4],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(3);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite5: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal5],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(4);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite6: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal6],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(5);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite7: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal7],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(6);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite8: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal8],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(7);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        },

        openFavorite9: {
            shortcut: [keyMap.ctrl, keyMap.shift, keyMap.normal9],
            performAction: function performAction() {
                var $menuItem = $favoriteMenuItems.eq(8);
                if ($menuItem.length) {
                    var link = $menuItem.find('a').prop('href');
                    window.open(link, '_self');
                }
            }
        }

    };

    // ------------------------------------------------------------------------
    // METHODS
    // ------------------------------------------------------------------------

    var _checkArrayEquality = function _checkArrayEquality(a, b) {
        if (a === b) {
            return true;
        }
        if (a == null || b === null) {
            return false;
        }
        if (a.length !== b.length) {
            return false;
        }

        for (var i = 0; i < a.length; ++i) {
            if (a[i] !== b[i]) {
                return false;
            }
        }

        return true;
    };

    var _checkShortcut = function _checkShortcut(keysPressed) {
        for (var map in shortcutMap) {
            if (shortcutMap.hasOwnProperty(map) && _checkArrayEquality(shortcutMap[map].shortcut, keysPressed)) {
                shortcutMap[map].performAction();
            }
        }
    };

    // ------------------------------------------------------------------------
    // EVENT HANDLER
    // ------------------------------------------------------------------------

    var _initialize = function _initialize() {
        $(document).on('keyup', function () {
            setTimeout(function () {
                _checkShortcut(keysPressed);
                keysPressed = [];
            }, 100);
        });

        $(document).on('keydown', function (event) {
            keysPressed.push(event.which);
        });
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        _initialize();
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
