<?php
/*--------------------------------------------------------------
   ProductListingVpeNumberFormatter.php 2023-06-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/
declare(strict_types=1);

namespace Gambio\Shop\Modules\ProductListing\App\Data\Vpe;

use Gambio\Shop\Modules\ProductListing\Model\ValueObjects\InternalToBeRenamed\ListingItemCurrency;

/**
 * Class ProductListingVpeNumberFormatter
 *
 * @package Gambio\Shop\Modules\ProductListing\App\Data\Vpe
 */
class ProductListingVpeNumberFormatter
{
    /**
     * @param float               $value
     * @param ListingItemCurrency $currency
     *
     * @return string
     */
    public function formatFloat(
        float $value,
        ListingItemCurrency $currency
    ): string {
        
        $left      = $currency->symbolLeft();
        $right     = $currency->symbolRight();
        $formatted = number_format($value, $currency->decimalPlaces(), $currency->decimalSeparator(), $currency->thousandsSeparator());
        $formatted = $left . ' ' . $formatted . ' ' . $right;
        
        return preg_replace('/\s+/', ' ', trim($formatted));
    }
}