<?php
/*--------------------------------------------------------------------------------------------------
    PropertyGroupBuilder.php 2020-02-17
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
declare(strict_types=1);

namespace Gambio\Shop\Properties\ProductModifiers\Database\Builders;

use Gambio\Shop\Properties\ProductModifiers\Database\PropertyGroup;
use Gambio\Shop\ProductModifiers\Groups\Builders\AbstractGroupBuilder;
use Gambio\Shop\ProductModifiers\Groups\GroupInterface;

/**
 * Class PropertyGroupBuilder
 * @package Gambio\Shop\Properties\ProductModifiers\Database\Builders
 */
class PropertyGroupBuilder extends AbstractGroupBuilder
{


    /**
     * @inheritDoc
     */
    protected function createInstance(): GroupInterface
    {
        return new PropertyGroup($this->id, $this->type, $this->name, $this->status, $this->modifiers());
    }


}