<?php
/*--------------------------------------------------------------
   CustomerFilterService.php 2021-12-20
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/
 
declare(strict_types=1);

namespace Gambio\Admin\Modules\Customer\Services;

use Gambio\Admin\Modules\Customer\Model\Collections\Customers;

/**
 * Interface CustomerFilterService
 *
 * @package Gambio\Admin\Modules\Customer\Services
 */
interface CustomerFilterService
{
    /**
     * Returns a filtered and paginated collection of customers based on the given filter and sorting arguments.
     * The filters must be a map, that assigns an attribute its filtering pattern.
     * The sorting must be a comma-separated list of attributes. A `-` can be used to change the order to descending.
     *
     * @param array       $filters
     * @param string|null $sorting
     * @param int         $limit
     * @param int         $offset
     *
     * @return Customers
     */
    public function filterCustomers(
        array   $filters,
        ?string $sorting = null,
        int     $limit = 25,
        int     $offset = 0
    ): Customers;
    
    
    /**
     * Returns total count of customers based on the given filter arguments.
     * The filters must be a map, that assigns an attribute it's filtering pattern.
     *
     * @param array $filters
     *
     * @return int
     */
    public function getCustomersTotalCount(array $filters): int;
}