<?php
/* --------------------------------------------------------------
  GxLogoOption.php 2019-08-14
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace Gambio\StyleEdit\Core\Components\GxLogo\Entities;

use Gambio\StyleEdit\Core\Components\ImageUpload\Entities\ImageUploadOption;
use Gambio\StyleEdit\Core\SingletonPrototype;
use GmConfigurationServiceInterface;
use ReflectionException;

/**
 * Class GxLogoOption
 */
class GxLogoOption extends ImageUploadOption
{
    /**
     * @var string
     */
    protected const GM_LOGO_CONFIGURATION_KEY = 'GM_LOGO_SHOP';
    
    /**
     * @var string
     */
    protected const GM_LOGO_WEBPATH = 'images/logos/';
    
    
    /**
     * @param $object
     *
     * @throws ReflectionException
     */
    public function initializeFromJsonObject($object): void
    {
        if (!isset($object->value)) {
            
            /** @var GmConfigurationServiceInterface $service */
            $service = SingletonPrototype::instance()->get(GmConfigurationServiceInterface::class);
            
            $gmLogoConfiguration = $service->getConfigurationByKey(self::GM_LOGO_CONFIGURATION_KEY);
            
            $object->value = self::GM_LOGO_WEBPATH . $gmLogoConfiguration->value();
        }
        
        parent::initializeFromJsonObject($object); // TODO: Change the autogenerated stub
    }
    
    
    /**
     * @return string
     */
    public function type(): ?string
    {
        return 'gx-logo';
    }
}