<?php
/*--------------------------------------------------------------------------------------------------
    GapiKeyOption.php 2020-08-13
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace GXModules\Gambio\StyleEdit\Core\Components\GapiKey\Entities;

use Gambio\StyleEdit\Core\Components\TextBox\Entities\TextBox;
use GXModules\Gambio\StyleEdit\Adapters\GmConfigurationAdapter;

class GapiKeyOption extends TextBox
{
    /**
     * @var GmConfigurationAdapter
     */
    private $adapter;
    
    /**
     * @var string
     */
    private $configurationNamespace;
    
    
    /**
     * GxGapiKeyOption constructor.
     *
     * @param GmConfigurationAdapter $adapter
     * @param string                 $configurationNamespace
     */
    public function __construct(GmConfigurationAdapter $adapter, string $configurationNamespace)
    {
        parent::__construct();
        $this->adapter                = $adapter;
        $this->configurationNamespace = $configurationNamespace;
    }
    
    
    /**
     * @param $object
     *
     * @throws \Exception
     */
    public function initializeFromJsonObject($object): void
    {
        if (empty($object->value)) {
            $object->value = $this->adapter->get($this->configurationNamespace)->value();
        }
        
        parent::initializeFromJsonObject($object); // TODO: Change the autogenerated stub
    }
    
    
    /**
     * @return string|null
     */
    public function type(): string
    {
        return 'gapi-key';
    }
}
