'use strict';

document.addEventListener('DOMContentLoaded', function () {
	var continueButton = document.querySelector('#checkout_payment div.continue_button input[type="submit"]'),
	    continueButtonText = continueButton.value;

	var paymentItemClickListener = function paymentItemClickListener() {
		var selected_payment = this.querySelector('input[name="payment"]');
		if (null !== selected_payment) {
			if (selected_payment.value === 'gambio_hub' && selected_payment.dataset.module_code === 'PayPal2InstallmentsHub') {
				continueButton.value = '#apply_for_installments';
			} else {
				continueButton.value = continueButtonText;
			}
		}
	};

	var paymentItems = document.querySelectorAll('#checkout_payment input[name="payment"], #checkout_payment li.list-group-item');
	paymentItems.forEach(function (paymentItem) {
		paymentItem.addEventListener('click', paymentItemClickListener);
	});

	document.querySelectorAll('#checkout_payment li').forEach(function (paymentOption) {
		if (paymentOption.querySelector('input[name="payment"]:checked')) {
			paymentOption.dispatchEvent(new Event('click'));
		}
	});
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
