'use strict';

(function () {
	var initPayPalCartButton = function initPayPalCartButton() {
		var dropdown = document.querySelector('#cart-container ul.dropdown-menu');
		if (!dropdown) {
			return;
		}

		var buttonConfiguration = {};
		var phrases = {};

		var newbutton = document.createElement('div');
		newbutton.classList.add('dropdown-footer');
		newbutton.classList.add('dropdown-paypal-button');
		newbutton.style.clear = 'both';
		newbutton.style.textAlign = 'center';
		newbutton.style.padding = '1ex 0 1em';
		newbutton.style.backgroundColor = 'inherit';
		var separator = document.createElement('div');
		separator.style.borderTop = '1px solid #ccc';
		separator.style.margin = '0 15px 20px';
		separator.style.position = 'relative';
		separator.style.backgroundColor = 'inherit';
		var introLabel = document.createElement('span');
		introLabel.style.display = 'block';
		introLabel.style.position = 'absolute';
		introLabel.style.top = '50%';
		introLabel.style.left = '50%';
		introLabel.style.transform = 'translateX(-50%) translateY(-50%)';
		introLabel.innerText = phrases.separatorLabel;
		introLabel.style.backgroundColor = 'inherit';
		separator.appendChild(introLabel);
		newbutton.appendChild(separator);
		var ppecs = document.createElement('span'),
		    logoImg = document.createElement('img'),
		    ppImg = document.createElement('img'),
		    pplink = document.createElement('a');
		logoImg.src = buttonConfiguration.logoUrl;
		logoImg.style.height = '20px';
		ppImg.src = buttonConfiguration.ppUrl;
		ppImg.style.height = '20px';
		ppecs.style.background = buttonConfiguration.backgroundColor;
		ppecs.style.border = '1px solid ' + buttonConfiguration.borderColor;
		ppecs.style.padding = '7px 2em';
		ppecs.style.marginLeft = '15px';
		ppecs.style.marginRight = '15px';
		ppecs.appendChild(ppImg);
		ppecs.appendChild(document.createTextNode(' '));
		ppecs.appendChild(logoImg);
		pplink.classList.add('paypal-ecs-button');
		pplink.href = 'shopping_cart.php?display_mode=ecs';
		pplink.appendChild(ppecs);
		newbutton.appendChild(pplink);
		var newli = document.createElement('li');
		newli.classList.add('dropdown-paypal-li');
		newli.style.backgroundColor = 'inherit';
		newli.appendChild(newbutton);

		dropdown.appendChild(newli);
	};

	document.addEventListener('DOMContentLoaded', function () {
		initPayPalCartButton();
		if (typeof $ !== 'undefined') {
			var $body = $('body');
			$body.on('CART_DROPDOWN_UPDATE', function () {
				window.setTimeout(initPayPalCartButton, 3000);
			});
		}
	});
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
