<?php
/*--------------------------------------------------------------
   CanaryIslandPostalCodeRegister.inc.php 2022-04-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/
declare(strict_types=1);

/**
 * Class CanaryIslandPostalCodeRegister
 */
class CanaryIslandPostalCodeRegister
{
    /**
     * @param int $postalCode
     *
     * @return bool
     */
    public static function postalCodeBelongsToCanaryIslands(int $postalCode): bool
    {
        return in_array($postalCode, self::getCanaryIslandPostalCodes(), true);
    }
    
    /**
     * @return array
     */
    protected static function getCanaryIslandPostalCodes(): array
    {
        return [
            35000,
            35001,
            35002,
            35003,
            35004,
            35005,
            35006,
            35007,
            35008,
            35009,
            35010,
            35011,
            35012,
            35013,
            35014,
            35015,
            35016,
            35017,
            35018,
            35019,
            35020,
            35070,
            35071,
            35080,
            35100,
            35106,
            35108,
            35118,
            35119,
            35120,
            35128,
            35129,
            35130,
            35139,
            35140,
            35149,
            35190,
            35192,
            35193,
            35194,
            35195,
            35196,
            35197,
            35198,
            35199,
            35200,
            35210,
            35211,
            35213,
            35216,
            35217,
            35220,
            35229,
            35230,
            35240,
            35249,
            35250,
            35260,
            35269,
            35280,
            35290,
            35307,
            35308,
            35319,
            35320,
            35328,
            35333,
            35338,
            35340,
            35349,
            35350,
            35360,
            35369,
            35400,
            35412,
            35414,
            35420,
            35421,
            35422,
            35423,
            35430,
            35431,
            35432,
            35450,
            35457,
            35458,
            35459,
            35460,
            35468,
            35470,
            35479,
            35488,
            35500,
            35507,
            35508,
            35510,
            35518,
            35519,
            35520,
            35530,
            35539,
            35540,
            35541,
            35542,
            35543,
            35544,
            35550,
            35559,
            35560,
            35570,
            35571,
            35572,
            35580,
            35600,
            35610,
            35611,
            35612,
            35613,
            35625,
            35626,
            35628,
            35629,
            35630,
            35637,
            35639,
            35640,
            35649,
            35650,
            35660,
            38001,
            38002,
            38003,
            38004,
            38005,
            38006,
            38007,
            38008,
            38009,
            38010,
            38070,
            38071,
            38080,
            38109,
            38110,
            38111,
            38120,
            38129,
            38130,
            38139,
            38140,
            38150,
            38160,
            38170,
            38180,
            38190,
            38200,
            38201,
            38202,
            38203,
            38204,
            38205,
            38206,
            38207,
            38208,
            38279,
            38289,
            38290,
            38292,
            38294,
            38295,
            38296,
            38298,
            38300,
            38310,
            38313,
            38314,
            38315,
            38320,
            38329,
            38330,
            38340,
            38350,
            38355,
            38356,
            38357,
            38358,
            38359,
            38360,
            38369,
            38370,
            38379,
            38380,
            38389,
            38390,
            38400,
            38410,
            38411,
            38412,
            38413,
            38414,
            38415,
            38416,
            38417,
            38418,
            38419,
            38420,
            38428,
            38429,
            38430,
            38434,
            38436,
            38438,
            38439,
            38440,
            38441,
            38449,
            38450,
            38458,
            38460,
            38470,
            38479,
            38480,
            38489,
            38500,
            38508,
            38530,
            38532,
            38550,
            38560,
            38580,
            38588,
            38589,
            38590,
            38593,
            38594,
            38595,
            38600,
            38611,
            38612,
            38613,
            38614,
            38615,
            38616,
            38617,
            38618,
            38619,
            38620,
            38626,
            38628,
            38629,
            38631,
            38639,
            38640,
            38649,
            38650,
            38652,
            38660,
            38670,
            38677,
            38678,
            38679,
            38680,
            38683,
            38684,
            38685,
            38686,
            38687,
            38689,
            38690,
            38700,
            38710,
            38712,
            38713,
            38714,
            38715,
            38726,
            38727,
            38728,
            38730,
            38738,
            38739,
            38740,
            38749,
            38750,
            38759,
            38768,
            38770,
            38779,
            38780,
            38787,
            38788,
            38789,
            38800,
            38801,
            38810,
            38811,
            38812,
            38813,
            38820,
            38829,
            38830,
            38840,
            38849,
            38850,
            38860,
            38869,
            38890,
            38891,
            38900,
            38910,
            38911,
            38913,
            38915,
            38917,
            49581,
        ];
    }
}