<?php

/* --------------------------------------------------------------
   CookieBarController.inc.php 2016-04-08 gm
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2016 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   -------------------------------------------------------------- 
*/

/**
 * Class CookieBarController
 *
 * @extends    HttpViewController
 * @category   System
 * @package    HttpViewControllers
 */
class CookieBarController extends HttpViewController
{
    public function actionDefault()
    {
        setcookie('hideCookieBar',
                  'true',
                  time() + 60 * 60 * 24,
                  '/',
            (isset($_SERVER['HTTP_HOST']) ? '.' . $_SERVER['HTTP_HOST'] : ''));
        
        $response = [
            'success' => true
        ];
        
        return MainFactory::create('JsonHttpControllerResponse', $response);
    }
}